/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.strategy.SubscriberMultiFetchTaskStrategy;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.Collection;

public class SubscriberMultiFetchTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriberMultiFetchTask.class);
    private final SessionServerConfig sessionServerConfig;
    private final TaskListenerManager taskListenerManager;
    private final CacheService sessionCacheService;
    private String fetchDataInfoId;
    private Collection<Subscriber> subscribers;
    private SubscriberMultiFetchTaskStrategy subscriberMultiFetchTaskStrategy;

    public SubscriberMultiFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, CacheService sessionCacheService, SubscriberMultiFetchTaskStrategy subscriberMultiFetchTaskStrategy) {
        this.sessionServerConfig = sessionServerConfig;
        this.taskListenerManager = taskListenerManager;
        this.sessionCacheService = sessionCacheService;
        this.subscriberMultiFetchTaskStrategy = subscriberMultiFetchTaskStrategy;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if (!((obj = taskEvent.getEventObj()) instanceof String)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.fetchDataInfoId = (String)obj;
        this.subscribers = (Collection)taskEvent.getAttribute("PUSH_CLIENT_SUBSCRIBERS");
        if (this.subscribers.isEmpty()) {
            LOGGER.error("Subscriber MultiFetchTask subscribers is empty!");
            throw new RuntimeException("Subscriber MultiFetchTask got exception!send subscribers is empty");
        }
    }

    public void execute() {
        this.subscriberMultiFetchTaskStrategy.doSubscriberMultiFetchTask(this.sessionServerConfig, this.taskListenerManager, this.sessionCacheService, this.fetchDataInfoId, this.subscribers);
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getDataChangeFetchTaskRetryTimes());
    }

    public String toString() {
        return "SUBSCRIBER_MULTI_FETCH_TASK {taskId='" + this.getTaskId() + '\'' + ", fetchDataInfoId=" + this.fetchDataInfoId + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }
}

