/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.dataserver.SessionServerRegisterRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.SessionProcessIdGenerator;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;

public class SessionRegisterDataTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionRegisterDataTask.class, (String)"[Task]");
    private final Exchange boltExchange;
    private final SessionServerConfig sessionServerConfig;
    private SessionServerRegisterRequest sessionServerRegisterRequest;
    private BoltChannel channel;

    public SessionRegisterDataTask(Exchange boltExchange, SessionServerConfig sessionServerConfig) {
        this.boltExchange = boltExchange;
        this.sessionServerConfig = sessionServerConfig;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getSessionRegisterDataServerTaskRetryTimes());
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if (!((obj = taskEvent.getEventObj()) instanceof BoltChannel)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.channel = (BoltChannel)obj;
        Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
        if (sessionServer != null) {
            Collection chs = sessionServer.getChannels();
            HashSet connectIds = new HashSet();
            chs.forEach(channel -> connectIds.add(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress())));
            this.sessionServerRegisterRequest = new SessionServerRegisterRequest(SessionProcessIdGenerator.getSessionProcessId(), connectIds);
        } else {
            LOGGER.error("get null session server,please check server started before register!port {}", (Object)this.sessionServerConfig.getServerPort());
            this.sessionServerRegisterRequest = new SessionServerRegisterRequest(SessionProcessIdGenerator.getSessionProcessId(), new HashSet());
        }
    }

    public void execute() {
        if (!this.channel.isConnected()) {
            return;
        }
        Client sessionClient = this.boltExchange.getClient("dataServer");
        try {
            sessionClient.sendSync((Channel)this.channel, (Object)this.sessionServerRegisterRequest, this.sessionServerConfig.getDataNodeExchangeTimeOut());
        }
        catch (Exception e) {
            if (this.isLastRetry()) {
                LOGGER.error("Register to DataServer({}/{}:{}) error for multiple times, so close this channel (let bolt reconnect it)", new Object[]{this.channel.getLocalAddress(), this.channel.getRemoteAddress().getHostString(), this.channel.getRemoteAddress().getPort()});
                this.channel.close();
            }
            throw e;
        }
    }

    protected boolean isLastRetry() {
        return this.getExecCount() >= this.sessionServerConfig.getSessionRegisterDataServerTaskRetryTimes();
    }

    public String toString() {
        return "SESSION_REGISTER_DATA_TASK{taskId='" + this.taskId + '\'' + ", sessionServerRegisterRequest=" + this.sessionServerRegisterRequest.getProcessId() + ", clientList=" + this.sessionServerRegisterRequest.getConnectIds().size() + ", channel=" + this.channel.getLocalAddress() + "/" + this.channel.getRemoteAddress().getHostString() + ':' + this.channel.getRemoteAddress().getPort() + '}';
    }
}

