/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.RenewDatumRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.registry.SessionRegistry;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;

public class RenewDatumTask
extends AbstractSessionTask {
    private static final Logger RENEW_LOGGER = LoggerFactory.getLogger((String)"RENEW-LOGGER", (String)"[RenewDatumTask]");
    private final DataNodeService dataNodeService;
    private final SessionServerConfig sessionServerConfig;
    private final SessionRegistry sessionRegistry;
    private RenewDatumRequest renewDatumRequest;

    public RenewDatumTask(SessionServerConfig sessionServerConfig, DataNodeService dataNodeService, SessionRegistry sessionRegistry) {
        this.sessionServerConfig = sessionServerConfig;
        this.dataNodeService = dataNodeService;
        this.sessionRegistry = sessionRegistry;
    }

    public void execute() {
        try {
            Boolean result = this.dataNodeService.renewDatum(this.renewDatumRequest);
            if (!result.booleanValue()) {
                RENEW_LOGGER.info("Renew datum request to dataNode got digest different! renewDatumRequest={}", (Object)this.renewDatumRequest);
                this.sessionRegistry.sendDatumSnapshot(this.renewDatumRequest.getConnectId(), this.renewDatumRequest.getDataServerIP());
            }
        }
        catch (Exception e) {
            RENEW_LOGGER.error(String.format("Renew datum request to dataNode error! renewDatumRequest=%s, errorMsg=%s", this.renewDatumRequest, e.getMessage()), (Throwable)e);
        }
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if (!((obj = taskEvent.getEventObj()) instanceof RenewDatumRequest)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.renewDatumRequest = (RenewDatumRequest)obj;
    }

    public String toString() {
        return String.format("RENEW_DATUM_TASK{ taskId=%s, renewDatumRequest=%s }", this.getTaskId(), this.renewDatumRequest);
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getRenewDatumTaskRetryTimes());
    }
}

