/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.PushDataRetryRequest;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.strategy.ReceivedDataMultiPushTaskStrategy;
import com.alipay.sofa.registry.task.Task;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReceivedDataMultiPushTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-PUSH", (String)"[Receive]");
    private final SessionServerConfig sessionServerConfig;
    private final ClientNodeService clientNodeService;
    private final ExecutorManager executorManager;
    private final Exchange boltExchange;
    private ReceivedData receivedData;
    private URL url;
    private TaskClosure taskClosure;
    private Collection<Subscriber> subscribers;
    private ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy;
    private AsyncHashedWheelTimer asyncHashedWheelTimer;
    private Interests sessionInterests;
    private String dataPush;

    public ReceivedDataMultiPushTask(SessionServerConfig sessionServerConfig, ClientNodeService clientNodeService, ExecutorManager executorManager, Exchange boltExchange, ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy, AsyncHashedWheelTimer asyncHashedWheelTimer, Interests sessionInterests) {
        this.sessionServerConfig = sessionServerConfig;
        this.clientNodeService = clientNodeService;
        this.executorManager = executorManager;
        this.boltExchange = boltExchange;
        this.receivedDataMultiPushTaskStrategy = receivedDataMultiPushTaskStrategy;
        this.asyncHashedWheelTimer = asyncHashedWheelTimer;
        this.sessionInterests = sessionInterests;
    }

    public void execute() {
        Object receivedDataPush = null;
        try {
            if (this.sessionServerConfig.isStopPushSwitch()) {
                LOGGER.info("Stop Push ReceivedData with switch on! dataId: {},group: {},Instance: {}, url: {}", new Object[]{this.receivedData.getDataId(), this.receivedData.getGroup(), this.receivedData.getInstanceId(), this.url});
                return;
            }
            final Object finalReceivedDataPush = receivedDataPush = this.receivedDataMultiPushTaskStrategy.convert2PushData(this.receivedData, this.url);
            CallbackHandler callbackHandler = new CallbackHandler(){

                public void onCallback(Channel channel, Object message) {
                    if (ReceivedDataMultiPushTask.this.taskClosure != null) {
                        ReceivedDataMultiPushTask.this.confirmCallBack(true);
                    }
                    LOGGER.info("Push ReceivedData success! dataId:{},group:{},Instance:{},version:{},url: {},dataPush:{}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.receivedData.getInstanceId(), ReceivedDataMultiPushTask.this.receivedData.getVersion(), ReceivedDataMultiPushTask.this.url, ReceivedDataMultiPushTask.this.dataPush});
                }

                public void onException(Channel channel, Throwable exception) {
                    try {
                        LOGGER.error("Push ReceivedData error! dataId:{},group:{},Instance:{},version:{},url: {},dataPush:{}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.receivedData.getInstanceId(), ReceivedDataMultiPushTask.this.receivedData.getVersion(), ReceivedDataMultiPushTask.this.url, ReceivedDataMultiPushTask.this.dataPush, exception});
                        if (ReceivedDataMultiPushTask.this.taskClosure != null) {
                            throw new RuntimeException("Push ReceivedData got exception from callback!");
                        }
                        ReceivedDataMultiPushTask.this.retrySendReceiveData(new PushDataRetryRequest(finalReceivedDataPush, ReceivedDataMultiPushTask.this.url));
                    }
                    finally {
                        if (ReceivedDataMultiPushTask.this.taskClosure != null) {
                            ReceivedDataMultiPushTask.this.confirmCallBack(false);
                        }
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            };
            this.clientNodeService.pushWithCallback(receivedDataPush, this.url, callbackHandler);
        }
        catch (Throwable e) {
            if (this.taskClosure != null) {
                this.confirmCallBack(false);
                throw e;
            }
            this.retrySendReceiveData(new PushDataRetryRequest(receivedDataPush, this.url));
        }
    }

    private void retrySendReceiveData(final PushDataRetryRequest pushDataRetryRequest) {
        if (this.taskClosure == null) {
            Object infoPackage = pushDataRetryRequest.getPushObj();
            final int retryTimes = pushDataRetryRequest.getRetryTimes().incrementAndGet();
            final URL targetUrl = pushDataRetryRequest.getUrl();
            if (this.checkRetryTimes(retryTimes)) {
                Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
                Channel channel = sessionServer.getChannel(targetUrl);
                if (channel != null && channel.isConnected()) {
                    this.asyncHashedWheelTimer.newTimeout(timeout -> {
                        try {
                            this.clientNodeService.pushWithCallback(infoPackage, targetUrl, new CallbackHandler(){

                                public void onCallback(Channel channel, Object message) {
                                    LOGGER.info("Retry Push ReceivedData success! dataId:{}, group:{},url:{},taskId:{},dataPush:{},retryTimes:{}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), targetUrl, ReceivedDataMultiPushTask.this.getTaskId(), ReceivedDataMultiPushTask.this.dataPush, retryTimes});
                                }

                                public void onException(Channel channel, Throwable exception) {
                                    LOGGER.error("Retry Push ReceivedData callback error! url:{}, dataId:{}, group:{},taskId:{},dataPush:{},retryTimes:{}", new Object[]{targetUrl, ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.getTaskId(), ReceivedDataMultiPushTask.this.dataPush, retryTimes});
                                    ReceivedDataMultiPushTask.this.retrySendReceiveData(pushDataRetryRequest);
                                }

                                public Executor getExecutor() {
                                    return null;
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.error("Retry Push ReceivedData error! url:{}, dataId:{}, group:{},taskId:{},dataPush:{},retryTimes:{}", new Object[]{targetUrl, this.receivedData.getDataId(), this.receivedData.getGroup(), this.getTaskId(), this.dataPush, retryTimes});
                            this.retrySendReceiveData(pushDataRetryRequest);
                        }
                    }, this.getBlockTime(retryTimes), TimeUnit.MILLISECONDS);
                } else {
                    LOGGER.error("Retry Push ReceivedData error, connect be null or disconnected,stop retry!dataId:{}, group:{},url:{},taskId:{},dataPush:{},retryTimes:{}", new Object[]{this.receivedData.getDataId(), this.receivedData.getGroup(), targetUrl, this.getTaskId(), this.dataPush, retryTimes});
                }
            } else {
                DataInfo dataInfo = new DataInfo(this.receivedData.getInstanceId(), this.receivedData.getDataId(), this.receivedData.getGroup());
                boolean result = this.sessionInterests.checkAndUpdateInterestVersionZero(this.receivedData.getSegment(), dataInfo.getDataInfoId());
                if (result) {
                    LOGGER.warn("Retry Push ReceivedData times have exceeded,set sessionInterests dataInfoId version zero! url:{},taskId:{},dataPush:{},retryTimes:{},dataCenter:{},dataInfoId:{}!", new Object[]{targetUrl, this.getTaskId(), this.dataPush, retryTimes, this.receivedData.getSegment(), dataInfo.getDataInfoId()});
                } else {
                    LOGGER.warn("Retry Push ReceivedData times have exceeded,but set sessionInterests dataInfoId version zero fail!url:{},taskId:{},dataPush:{},retryTimes:{},dataCenter:{},dataInfoId:{}!", new Object[]{targetUrl, this.getTaskId(), this.dataPush, retryTimes, this.receivedData.getSegment(), dataInfo.getDataInfoId()});
                }
            }
        }
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if ((obj = taskEvent.getEventObj()) instanceof Map) {
            Map parameter = (Map)obj;
            if (parameter.size() == 1) {
                Map.Entry entry = parameter.entrySet().iterator().next();
                ReceivedData receivedData = (ReceivedData)entry.getKey();
                URL url = (URL)entry.getValue();
                this.receivedData = receivedData;
                this.url = url;
            } else {
                throw new IllegalArgumentException("Input task event object error!");
            }
        }
        if (this.receivedData != null && this.receivedData.getData() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Map map = this.receivedData.getData();
            if (!map.isEmpty()) {
                for (Map.Entry entry1 : map.entrySet()) {
                    sb.append((String)entry1.getKey()).append("=");
                    int size = entry1.getValue() != null ? ((List)entry1.getValue()).size() : 0;
                    sb.append(size).append(",");
                }
            }
            sb.append("]");
            this.dataPush = sb.toString();
        }
        this.taskClosure = taskEvent.getTaskClosure();
        this.subscribers = (Collection)taskEvent.getAttribute("PUSH_CLIENT_SUBSCRIBERS");
        if (this.taskClosure != null && this.subscribers.isEmpty()) {
            LOGGER.error("send Receive data subscribers is empty!");
            throw new RuntimeException("Push Receive data got exception!send subscribers is empty");
        }
    }

    private void confirmCallBack(boolean result) {
        if (this.taskClosure != null) {
            this.executorManager.getCheckPushExecutor().execute(() -> {
                if (result) {
                    this.subscribers.forEach(subscriber -> subscriber.checkAndUpdateVersion(this.receivedData.getSegment(), this.receivedData.getVersion()));
                    this.taskClosure.run(TaskProcessor.ProcessingResult.Success, (Task)this);
                } else {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.PermanentError, (Task)this);
                }
            });
        }
    }

    public String toString() {
        return "RECEIVED_DATA_MULTI_PUSH_TASK{taskId='" + this.getTaskId() + '\'' + ", receivedData=" + this.receivedData + ", url=" + this.url + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }

    @Override
    protected boolean checkRetryTimes(int retryTimes) {
        int configTimes = this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes();
        if (configTimes > 0) {
            return retryTimes <= configTimes;
        }
        return false;
    }

    private long getBlockTime(int retry) {
        long increment;
        long initialSleepTime = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getPushDataTaskRetryFirstDelay());
        long result = initialSleepTime + (increment = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getPushDataTaskRetryIncrementDelay())) * (long)(retry - 1);
        return result >= 0L ? result : 0L;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes());
    }
}

