/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedConfigData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.strategy.ReceivedConfigDataPushTaskStrategy;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.util.Map;
import java.util.concurrent.Executor;

public class ReceivedConfigDataPushTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedConfigDataPushTask.class, (String)"[Task]");
    private final SessionServerConfig sessionServerConfig;
    private final ClientNodeService clientNodeService;
    private ReceivedConfigData receivedConfigData;
    private URL url;
    private ReceivedConfigDataPushTaskStrategy receivedConfigDataPushTaskStrategy;

    public ReceivedConfigDataPushTask(SessionServerConfig sessionServerConfig, ClientNodeService clientNodeService, ReceivedConfigDataPushTaskStrategy receivedConfigDataPushTaskStrategy) {
        this.sessionServerConfig = sessionServerConfig;
        this.clientNodeService = clientNodeService;
        this.receivedConfigDataPushTaskStrategy = receivedConfigDataPushTaskStrategy;
    }

    public void execute() {
        if (this.sessionServerConfig.isStopPushSwitch()) {
            LOGGER.info("Stop Push receivedConfigData with switch on! dataId: {},group: {},Instance: {}, url: {}", new Object[]{this.receivedConfigData.getDataId(), this.receivedConfigData.getGroup(), this.receivedConfigData.getInstanceId(), this.url});
            return;
        }
        CallbackHandler callbackHandler = new CallbackHandler(){

            public void onCallback(Channel channel, Object message) {
                LOGGER.info("Push receivedConfigData success! dataId: {},group: {},Instance: {}, url: {}", new Object[]{ReceivedConfigDataPushTask.this.receivedConfigData.getDataId(), ReceivedConfigDataPushTask.this.receivedConfigData.getGroup(), ReceivedConfigDataPushTask.this.receivedConfigData.getInstanceId(), ReceivedConfigDataPushTask.this.url});
            }

            public void onException(Channel channel, Throwable exception) {
                LOGGER.error("Push receivedConfigData error! dataId: {},group: {},Instance: {}, url: {}", new Object[]{ReceivedConfigDataPushTask.this.receivedConfigData.getDataId(), ReceivedConfigDataPushTask.this.receivedConfigData.getGroup(), ReceivedConfigDataPushTask.this.receivedConfigData.getInstanceId(), ReceivedConfigDataPushTask.this.url});
            }

            public Executor getExecutor() {
                return null;
            }
        };
        this.clientNodeService.pushWithCallback(this.receivedConfigDataPushTaskStrategy.convert2PushData(this.receivedConfigData, this.url), this.url, callbackHandler);
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj;
        if (taskEvent.getTaskId() != null) {
            this.setTaskId(taskEvent.getTaskId());
        }
        if ((obj = taskEvent.getEventObj()) instanceof Map) {
            Map parameter = (Map)obj;
            if (parameter.size() == 1) {
                Map.Entry entry = parameter.entrySet().iterator().next();
                ReceivedConfigData receivedData = (ReceivedConfigData)entry.getKey();
                URL url = (URL)entry.getValue();
                this.receivedConfigData = receivedData;
                this.url = url;
            } else {
                throw new IllegalArgumentException("Input task event object error!");
            }
        }
    }

    public String toString() {
        return "RECEIVED_DATA_CONFIG_PUSH_TASK{taskId='" + this.getTaskId() + '\'' + ", receivedConfigData=" + this.receivedConfigData + ", url=" + this.url + ", retry='" + this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes() + '\'' + '}';
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes());
    }
}

