/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.task.Task;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PushTaskClosure
implements TaskClosure {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushTaskClosure.class);
    private Set<String> tasks = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<String, TaskProcessor.ProcessingResult> taskResultMap = new ConcurrentHashMap();
    private TaskClosure taskClosure;
    private final AsyncHashedWheelTimer pushTaskCheckAsyncHashedWheelTimer;
    private final SessionServerConfig sessionServerConfig;
    private final String dataInfoId;

    public PushTaskClosure(AsyncHashedWheelTimer pushTaskCheckAsyncHashedWheelTimer, SessionServerConfig sessionServerConfig, String dataInfoId) {
        this.pushTaskCheckAsyncHashedWheelTimer = pushTaskCheckAsyncHashedWheelTimer;
        this.sessionServerConfig = sessionServerConfig;
        this.dataInfoId = dataInfoId;
    }

    public void run(TaskProcessor.ProcessingResult processingResult, Task task) {
        TaskProcessor.ProcessingResult result;
        if (task != null && (result = this.taskResultMap.putIfAbsent(task.getTaskId(), processingResult)) == null && processingResult == TaskProcessor.ProcessingResult.Success) {
            this.tasks.remove(task.getTaskId());
            if (this.tasks.isEmpty()) {
                LOGGER.info("Push all tasks success,dataInfoId={}", (Object)this.dataInfoId);
                if (this.taskClosure != null) {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.Success, null);
                }
            }
        }
    }

    public void addTask(TaskEvent taskEvent) {
        this.tasks.add(taskEvent.getTaskId());
    }

    public void start() {
        int size = this.tasks.size();
        LOGGER.info("Push task confirm,dataInfoId={},all task size={}", (Object)this.dataInfoId, (Object)size);
        this.pushTaskCheckAsyncHashedWheelTimer.newTimeout(timeout -> {
            if (!this.tasks.isEmpty()) {
                LOGGER.warn("Push tasks found error tasks {},dataInfoId={}!", (Object)this.tasks.size(), (Object)this.dataInfoId);
                if (this.taskClosure != null) {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.PermanentError, null);
                }
            }
        }, this.sessionServerConfig.getPushTaskConfirmWaitTimeout(), TimeUnit.MILLISECONDS);
    }

    public Set<String> getTasks() {
        return this.tasks;
    }

    public void setTaskClosure(TaskClosure taskClosure) {
        this.taskClosure = taskClosure;
    }
}

