/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.task.Retryable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSessionTask
implements SessionTask,
Retryable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSessionTask.class, (String)"[Task]");
    protected volatile String taskId;
    private AtomicInteger execCount = new AtomicInteger(1);

    public synchronized String getTaskId() {
        if (this.taskId == null) {
            this.taskId = UUID.randomUUID().toString();
        }
        return this.taskId;
    }

    protected synchronized void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    protected boolean checkRetryTimes(int configTimes) {
        if (configTimes > 0) {
            if (this.execCount.incrementAndGet() > configTimes) {
                LOGGER.info(" info:{} retry times more than {}", (Object)this, (Object)configTimes);
                return false;
            }
            return true;
        }
        return false;
    }

    protected int getExecCount() {
        return this.execCount.get();
    }

    public long getExpiryTime() {
        return -1L;
    }
}

