/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.TaskMetrics;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SessionThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionThreadPoolExecutor.class);
    private String executorName;

    public SessionThreadPoolExecutor(String executorName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.executorName = executorName;
        this.registerTaskMetrics();
        this.setRejectedExecutionHandler(handler);
    }

    public SessionThreadPoolExecutor(String executorName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(executorName, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, (r, executor) -> {
            String msg = String.format("Task(%s) %s rejected from %s, throw RejectedExecutionException.", r.getClass(), r, executor);
            LOGGER.error(msg);
            throw new RejectedExecutionException(msg);
        });
    }

    private void registerTaskMetrics() {
        TaskMetrics.getInstance().registerThreadExecutor(this.executorName, (ThreadPoolExecutor)this);
    }

    @Override
    public String toString() {
        return this.executorName + " " + super.toString();
    }
}

