/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.TaskMetrics;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.scheduler.SessionThreadPoolExecutor;
import com.alipay.sofa.registry.task.scheduler.TimedSupervisorTask;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorManager.class);
    private final ScheduledThreadPoolExecutor scheduler;
    private final ThreadPoolExecutor fetchDataExecutor;
    private final ThreadPoolExecutor standaloneCheckVersionExecutor;
    private final ThreadPoolExecutor renNewDataExecutor;
    private final ThreadPoolExecutor getSessionNodeExecutor;
    private final ThreadPoolExecutor connectMetaExecutor;
    private final ThreadPoolExecutor connectDataExecutor;
    private final ExecutorService checkPushExecutor;
    private final ThreadPoolExecutor accessDataExecutor;
    private final ThreadPoolExecutor dataChangeRequestExecutor;
    private final ThreadPoolExecutor pushTaskExecutor;
    private final ThreadPoolExecutor connectClientExecutor;
    private final ThreadPoolExecutor publishDataExecutor;
    private final ThreadPoolExecutor cleanInvalidClientExecutor;
    private final AsyncHashedWheelTimer pushTaskCheckAsyncHashedWheelTimer;
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private NodeManager sessionNodeManager;
    @Autowired
    private NodeManager dataNodeManager;
    @Autowired
    private NodeManager metaNodeManager;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    private NodeExchanger dataNodeExchanger;
    private Map<String, ThreadPoolExecutor> reportExecutors = new HashMap<String, ThreadPoolExecutor>();
    private static final String PUSH_TASK_EXECUTOR = "PushTaskExecutor";
    private static final String ACCESS_DATA_EXECUTOR = "AccessDataExecutor";
    private static final String DATA_CHANGE_REQUEST_EXECUTOR = "DataChangeRequestExecutor";
    private static final String USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR = "UserDataElementPushCheckExecutor";
    private static final String PUSH_TASK_CLOSURE_CHECK_EXECUTOR = "PushTaskClosureCheckExecutor";
    private static final String CONNECT_CLIENT_EXECUTOR = "ConnectClientExecutor";
    private static final String PUBLISH_DATA_EXECUTOR = "PublishDataExecutor";

    public ExecutorManager(SessionServerConfig sessionServerConfig) {
        this.sessionServerConfig = sessionServerConfig;
        this.scheduler = new ScheduledThreadPoolExecutor(sessionServerConfig.getSessionSchedulerPoolSize(), (ThreadFactory)new NamedThreadFactory("SessionScheduler"));
        this.fetchDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-fetchData"));
        this.renNewDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-renewData"));
        this.getSessionNodeExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-getSessionNode"));
        this.standaloneCheckVersionExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-standaloneCheckVersion"));
        this.connectMetaExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-connectMetaServer"));
        this.connectDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-connectDataServer"));
        this.cleanInvalidClientExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-cleanInvalidClient"));
        this.accessDataExecutor = this.reportExecutors.computeIfAbsent(ACCESS_DATA_EXECUTOR, k -> new SessionThreadPoolExecutor(ACCESS_DATA_EXECUTOR, sessionServerConfig.getAccessDataExecutorMinPoolSize(), sessionServerConfig.getAccessDataExecutorMaxPoolSize(), sessionServerConfig.getAccessDataExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(sessionServerConfig.getAccessDataExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("AccessData-executor", true), (r, executor) -> {
            String msg = String.format("Task(%s) %s rejected from %s, just ignore it to let client timeout.", r.getClass(), r, executor);
            LOGGER.error(msg);
        }));
        this.pushTaskExecutor = this.reportExecutors.computeIfAbsent(PUSH_TASK_EXECUTOR, k -> new ThreadPoolExecutor(sessionServerConfig.getPushTaskExecutorMinPoolSize(), sessionServerConfig.getPushTaskExecutorMaxPoolSize(), sessionServerConfig.getPushTaskExecutorKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(sessionServerConfig.getPushTaskExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("PushTask-executor", true)));
        TaskMetrics.getInstance().registerThreadExecutor(PUSH_TASK_EXECUTOR, this.pushTaskExecutor);
        this.dataChangeRequestExecutor = this.reportExecutors.computeIfAbsent(DATA_CHANGE_REQUEST_EXECUTOR, k -> new SessionThreadPoolExecutor(DATA_CHANGE_REQUEST_EXECUTOR, sessionServerConfig.getDataChangeExecutorMinPoolSize(), sessionServerConfig.getDataChangeExecutorMaxPoolSize(), sessionServerConfig.getDataChangeExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(sessionServerConfig.getDataChangeExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("DataChangeRequestHandler-executor", true)));
        this.checkPushExecutor = this.reportExecutors.computeIfAbsent(USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR, k -> new SessionThreadPoolExecutor(USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR, 100, 600, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(150000), (ThreadFactory)new NamedThreadFactory("UserDataElementPushCheck-executor", true)));
        this.connectClientExecutor = this.reportExecutors.computeIfAbsent(CONNECT_CLIENT_EXECUTOR, k -> new SessionThreadPoolExecutor(CONNECT_CLIENT_EXECUTOR, sessionServerConfig.getConnectClientExecutorMinPoolSize(), sessionServerConfig.getConnectClientExecutorMaxPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(sessionServerConfig.getConnectClientExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("DisconnectClientExecutor", true)));
        this.pushTaskCheckAsyncHashedWheelTimer = new AsyncHashedWheelTimer((ThreadFactory)new NamedThreadFactory("PushTaskConfirmCheck-executor", true), (long)sessionServerConfig.getPushTaskConfirmCheckWheelTicksDuration(), TimeUnit.MILLISECONDS, sessionServerConfig.getPushTaskConfirmCheckWheelTicksSize(), sessionServerConfig.getPushTaskConfirmCheckExecutorThreadSize(), sessionServerConfig.getPushTaskConfirmCheckExecutorQueueSize(), new ThreadFactoryBuilder().setNameFormat("PushTaskConfirmCheck-executor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
        this.publishDataExecutor = this.reportExecutors.computeIfAbsent(PUBLISH_DATA_EXECUTOR, k -> new SessionThreadPoolExecutor(PUBLISH_DATA_EXECUTOR, sessionServerConfig.getPublishDataExecutorMinPoolSize(), sessionServerConfig.getPublishDataExecutorMaxPoolSize(), sessionServerConfig.getPublishDataExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(sessionServerConfig.getPublishDataExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("PublishData-executor", true)));
    }

    public void startScheduler() {
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("FetchData", (ScheduledExecutorService)this.scheduler, this.fetchDataExecutor, this.sessionServerConfig.getSchedulerFetchDataTimeout(), TimeUnit.MINUTES, this.sessionServerConfig.getSchedulerFetchDataExpBackOffBound(), () -> this.sessionRegistry.fetchChangData()), (long)this.sessionServerConfig.getSchedulerFetchDataFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("RenewData", (ScheduledExecutorService)this.scheduler, this.renNewDataExecutor, this.sessionServerConfig.getSchedulerHeartbeatTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerHeartbeatExpBackOffBound(), () -> this.sessionNodeManager.renewNode()), (long)this.sessionServerConfig.getSchedulerHeartbeatFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("GetSessionNode", (ScheduledExecutorService)this.scheduler, this.getSessionNodeExecutor, this.sessionServerConfig.getSchedulerGetSessionNodeTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerGetSessionNodeExpBackOffBound(), () -> {
            this.sessionNodeManager.getAllDataCenterNodes();
            this.dataNodeManager.getAllDataCenterNodes();
            this.metaNodeManager.getAllDataCenterNodes();
        }), (long)this.sessionServerConfig.getSchedulerGetSessionNodeFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ConnectMetaServer", (ScheduledExecutorService)this.scheduler, this.connectMetaExecutor, this.sessionServerConfig.getSchedulerConnectMetaTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerConnectMetaExpBackOffBound(), () -> this.metaNodeExchanger.connectServer()), (long)this.sessionServerConfig.getSchedulerConnectMetaFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ConnectDataServer", (ScheduledExecutorService)this.scheduler, this.connectDataExecutor, this.sessionServerConfig.getSchedulerConnectDataTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerConnectDataExpBackOffBound(), () -> this.dataNodeExchanger.connectServer()), (long)this.sessionServerConfig.getSchedulerConnectDataFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("CleanInvalidClient", (ScheduledExecutorService)this.scheduler, this.cleanInvalidClientExecutor, this.sessionServerConfig.getSchedulerCleanInvalidClientTimeOut(), TimeUnit.MINUTES, this.sessionServerConfig.getSchedulerCleanInvalidClientBackOffBound(), () -> this.sessionRegistry.cleanClientConnect()), (long)this.sessionServerConfig.getSchedulerCleanInvalidClientFirstDelay(), TimeUnit.MINUTES);
    }

    public void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        if (this.standaloneCheckVersionExecutor != null && !this.standaloneCheckVersionExecutor.isShutdown()) {
            this.standaloneCheckVersionExecutor.shutdown();
        }
        if (this.renNewDataExecutor != null && !this.renNewDataExecutor.isShutdown()) {
            this.renNewDataExecutor.shutdown();
        }
        if (this.fetchDataExecutor != null && !this.fetchDataExecutor.isShutdown()) {
            this.fetchDataExecutor.shutdown();
        }
        if (this.getSessionNodeExecutor != null && !this.getSessionNodeExecutor.isShutdown()) {
            this.getSessionNodeExecutor.shutdown();
        }
        if (this.connectMetaExecutor != null && !this.connectMetaExecutor.isShutdown()) {
            this.connectMetaExecutor.shutdown();
        }
        if (this.connectDataExecutor != null && !this.connectDataExecutor.isShutdown()) {
            this.connectDataExecutor.shutdown();
        }
        if (this.accessDataExecutor != null && !this.accessDataExecutor.isShutdown()) {
            this.accessDataExecutor.shutdown();
        }
        if (this.pushTaskExecutor != null && !this.pushTaskExecutor.isShutdown()) {
            this.pushTaskExecutor.shutdown();
        }
        if (this.checkPushExecutor != null && !this.checkPushExecutor.isShutdown()) {
            this.checkPushExecutor.shutdown();
        }
        if (this.dataChangeRequestExecutor != null && !this.dataChangeRequestExecutor.isShutdown()) {
            this.dataChangeRequestExecutor.shutdown();
        }
        if (this.connectClientExecutor != null && !this.connectClientExecutor.isShutdown()) {
            this.connectClientExecutor.shutdown();
        }
        if (this.publishDataExecutor != null && !this.publishDataExecutor.isShutdown()) {
            this.publishDataExecutor.shutdown();
        }
    }

    public Map<String, ThreadPoolExecutor> getReportExecutors() {
        return this.reportExecutors;
    }

    public ThreadPoolExecutor getAccessDataExecutor() {
        return this.accessDataExecutor;
    }

    public ThreadPoolExecutor getPushTaskExecutor() {
        return this.pushTaskExecutor;
    }

    public ExecutorService getCheckPushExecutor() {
        return this.checkPushExecutor;
    }

    public ThreadPoolExecutor getDataChangeRequestExecutor() {
        return this.dataChangeRequestExecutor;
    }

    public ThreadPoolExecutor getConnectClientExecutor() {
        return this.connectClientExecutor;
    }

    public AsyncHashedWheelTimer getPushTaskCheckAsyncHashedWheelTimer() {
        return this.pushTaskCheckAsyncHashedWheelTimer;
    }

    public ThreadPoolExecutor getPublishDataExecutor() {
        return this.publishDataExecutor;
    }
}

