/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.renew;

import com.alipay.sofa.registry.common.model.DatumSnapshotRequest;
import com.alipay.sofa.registry.common.model.PublisherDigestUtil;
import com.alipay.sofa.registry.common.model.RenewDatumRequest;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.renew.RenewService;
import com.alipay.sofa.registry.server.session.store.DataStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultRenewService
implements RenewService {
    @Autowired
    private DataStore sessionDataStore;
    @Autowired
    private NodeManager dataNodeManager;

    @Override
    public List<RenewDatumRequest> getRenewDatumRequests(String connectId) {
        List<DatumSnapshotRequest> datumSnapshotRequests = this.getDatumSnapshotRequest(connectId);
        if (datumSnapshotRequests != null && !datumSnapshotRequests.isEmpty()) {
            return datumSnapshotRequests.stream().map(datumSnapshotRequest -> new RenewDatumRequest(datumSnapshotRequest.getConnectId(), datumSnapshotRequest.getDataServerIp(), String.valueOf(PublisherDigestUtil.getDigestValueSum((Collection)datumSnapshotRequest.getPublishers())))).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<DatumSnapshotRequest> getDatumSnapshotRequest(String connectId) {
        Map pubMap = this.sessionDataStore.queryByConnectId(connectId);
        if (pubMap != null && !pubMap.isEmpty()) {
            ConcurrentHashMap dataServerIpToPubs = new ConcurrentHashMap();
            ArrayList<DatumSnapshotRequest> list = new ArrayList<DatumSnapshotRequest>();
            pubMap.values().forEach(publisher -> {
                Object dataNode = this.dataNodeManager.getNode(publisher.getDataInfoId());
                List publishers = dataServerIpToPubs.computeIfAbsent(dataNode.getNodeUrl().getIpAddress(), k -> new ArrayList());
                publishers.add(publisher);
            });
            for (Map.Entry entry : dataServerIpToPubs.entrySet()) {
                List publishers = (List)entry.getValue();
                if (publishers.isEmpty()) continue;
                DatumSnapshotRequest datumSnapshotRequest = new DatumSnapshotRequest(connectId, (String)entry.getKey(), publishers);
                list.add(datumSnapshotRequest);
            }
            return list;
        }
        return null;
    }

    @Override
    public DatumSnapshotRequest getDatumSnapshotRequest(String connectId, String dataServerIP) {
        ArrayList publishers = new ArrayList();
        Map pubMap = this.sessionDataStore.queryByConnectId(connectId);
        if (pubMap != null && !pubMap.isEmpty()) {
            pubMap.values().forEach(publisher -> {
                Object dataNode = this.dataNodeManager.getNode(publisher.getDataInfoId());
                if (dataServerIP.equalsIgnoreCase(dataNode.getNodeUrl().getIpAddress())) {
                    publishers.add(publisher);
                }
            });
        }
        if (!publishers.isEmpty()) {
            return new DatumSnapshotRequest(connectId, dataServerIP, publishers);
        }
        return null;
    }
}

