/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyProvideDataChangeHandler
extends AbstractClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyProvideDataChangeHandler.class);
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(NotifyProvideDataChangeHandler.class, (String)"[Task]");
    @Autowired
    private Watchers sessionWatchers;
    @Autowired
    private TaskListenerManager taskListenerManager;

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    public Object reply(Channel channel, Object message) {
        boolean result;
        NotifyProvideDataChange notifyProvideDataChange = (NotifyProvideDataChange)message;
        if (!("session.stop.push.data.switch#@#9600#@#CONFIG".equals(notifyProvideDataChange.getDataInfoId()) || "session.blacklist.data#@#9600#@#CONFIG".equals(notifyProvideDataChange.getDataInfoId()) || "session.enable.datum.renew.switch#@#9600#@#CONFIG".equals(notifyProvideDataChange.getDataInfoId()) || (result = this.sessionWatchers.checkWatcherVersions(notifyProvideDataChange.getDataInfoId(), notifyProvideDataChange.getVersion())))) {
            LOGGER.info("Request message dataInfo {}, version {} not be interested or lower than current version!", (Object)notifyProvideDataChange.getDataInfoId(), (Object)notifyProvideDataChange.getVersion());
            return null;
        }
        this.fireDataChangeFetchTask(notifyProvideDataChange);
        return null;
    }

    private void fireDataChangeFetchTask(NotifyProvideDataChange notifyProvideDataChange) {
        TaskEvent taskEvent = new TaskEvent((Object)notifyProvideDataChange, TaskEvent.TaskType.PROVIDE_DATA_CHANGE_FETCH_TASK);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public Class interest() {
        return NotifyProvideDataChange.class;
    }
}

