/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.sessionserver.DataChangeRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.DatumKey;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.strategy.DataChangeRequestHandlerStrategy;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;

public class DataChangeRequestHandler
extends AbstractClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataChangeRequestHandler.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE");
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private CacheService sessionCacheService;
    @Autowired
    private DataChangeRequestHandlerStrategy dataChangeRequestHandlerStrategy;

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    public Executor getExecutor() {
        return this.executorManager.getDataChangeRequestExecutor();
    }

    public Object reply(Channel channel, Object message) {
        DataChangeRequest dataChangeRequest = (DataChangeRequest)message;
        dataChangeRequest.setDataCenter(dataChangeRequest.getDataCenter());
        dataChangeRequest.setDataInfoId(dataChangeRequest.getDataInfoId());
        this.sessionCacheService.invalidate(new Key(Key.KeyType.OBJ, DatumKey.class.getName(), new DatumKey(dataChangeRequest.getDataInfoId(), dataChangeRequest.getDataCenter())));
        if (this.sessionServerConfig.isStopPushSwitch()) {
            return null;
        }
        try {
            boolean result = this.sessionInterests.checkInterestVersions(dataChangeRequest.getDataCenter(), dataChangeRequest.getDataInfoId(), dataChangeRequest.getVersion());
            if (!result) {
                return null;
            }
            EXCHANGE_LOGGER.info("Data version has change,and will fetch to update!Request={},URL={}", (Object)dataChangeRequest, (Object)channel.getRemoteAddress());
            this.fireChangFetch(dataChangeRequest);
        }
        catch (Exception e) {
            LOGGER.error("DataChange Request error!", (Throwable)e);
            throw new RuntimeException("DataChangeRequest Request error!", e);
        }
        return null;
    }

    private void fireChangFetch(DataChangeRequest dataChangeRequest) {
        this.dataChangeRequestHandlerStrategy.doFireChangFetch(dataChangeRequest);
    }

    @Override
    public Class interest() {
        return DataChangeRequest.class;
    }
}

