/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.alipay.sofa.registry.timer.RecycleAsyncHashedWheelTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientNodeConnectionHandler
extends AbstractServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-CONNECT");
    private static final Logger RENEW_LOGGER = LoggerFactory.getLogger((String)"RENEW-LOGGER", (String)"[ClientNodeConnectionHandler]");
    private RecycleAsyncHashedWheelTimer recycleAsyncHashedWheelTimer;
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private DataStore sessionDataStore;
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private Watchers sessionWatchers;
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Exchange boltExchange;

    @PostConstruct
    public void init() {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.recycleAsyncHashedWheelTimer = new RecycleAsyncHashedWheelTimer(threadFactoryBuilder.setNameFormat("Registry-RenewDatumTask-WheelTimer").build(), (long)this.sessionServerConfig.getRenewDatumWheelTicksDuration(), TimeUnit.MILLISECONDS, this.sessionServerConfig.getRenewDatumWheelTicksSize(), this.sessionServerConfig.getRenewDatumWheelThreadSize(), this.sessionServerConfig.getRenewDatumWheelQueueSize(), threadFactoryBuilder.setNameFormat("Registry-RenewDatumTask-WheelExecutor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                RENEW_LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                RENEW_LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.LISENTER;
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        this.fireRenewDatum(channel);
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        this.fireCancelClient(channel);
    }

    private void fireCancelClient(Channel channel) {
        this.executorManager.getConnectClientExecutor().execute(() -> {
            String connectId = NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress());
            if (this.checkCache(connectId)) {
                ArrayList<String> connectIds = new ArrayList<String>();
                connectIds.add(connectId);
                this.sessionRegistry.cancel(connectIds);
            }
        });
    }

    private boolean checkCache(String connectId) {
        boolean checkSub = this.checkSub(connectId);
        boolean checkPub = this.checkPub(connectId);
        boolean checkWatcher = this.checkWatcher(connectId);
        LOGGER.info("Client off checkCache connectId:{} result pub:{},sub:{},wat:{}", new Object[]{connectId, checkPub, checkSub, checkWatcher});
        return checkPub || checkSub || checkWatcher;
    }

    private boolean checkPub(String connectId) {
        Map pubMap = this.sessionDataStore.queryByConnectId(connectId);
        return pubMap != null && !pubMap.isEmpty();
    }

    private boolean checkSub(String connectId) {
        Map subMap = this.sessionInterests.queryByConnectId(connectId);
        return subMap != null && !subMap.isEmpty();
    }

    private boolean checkWatcher(String connectId) {
        Map subMap = this.sessionWatchers.queryByConnectId(connectId);
        return subMap != null && !subMap.isEmpty();
    }

    private void fireRenewDatum(Channel channel) {
        this.executorManager.getConnectClientExecutor().execute(() -> {
            String connectId = NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress());
            RENEW_LOGGER.info("Renew task is started: {}", (Object)connectId);
            this.recycleAsyncHashedWheelTimer.newTimeout(timerOut -> this.sessionRegistry.renewDatum(connectId), this.randomDelay(), (long)this.sessionServerConfig.getRenewDatumWheelTaskDelaySec(), TimeUnit.SECONDS, () -> {
                boolean shouldContinue;
                Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
                Channel channelClient = sessionServer.getChannel(URL.valueOf((String)connectId));
                boolean bl = shouldContinue = channelClient != null && channel.isConnected();
                if (!shouldContinue) {
                    RENEW_LOGGER.info("Renew task is stop: {}", (Object)connectId);
                }
                return shouldContinue;
            });
        });
    }

    private long randomDelay() {
        return this.sessionServerConfig.getRenewDatumWheelTaskRandomFirstDelaySec() / 2 + RandomUtils.nextInt((int)(this.sessionServerConfig.getRenewDatumWheelTaskRandomFirstDelaySec() / 2));
    }
}

