/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting;

import com.alipay.sofa.registry.common.model.metaserver.MetaNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaNodeExchanger.class);
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Resource(name="metaClientHandlers")
    private Collection<AbstractClientHandler> metaClientHandlers;
    @Autowired
    private RaftClientManager raftClientManager;
    @Autowired
    private NodeManager metaNodeManager;

    public Response request(Request request) throws RequestException {
        Response response;
        URL url = request.getRequestUrl();
        try {
            Client sessionClient = this.boltExchange.getClient("metaServer");
            if (sessionClient == null) {
                LOGGER.warn("MetaNode Exchanger get dataServer connection {} error! Connection can not be null or disconnected!", (Object)url);
                sessionClient = this.boltExchange.connect("metaServer", url, (Object[])this.metaClientHandlers.toArray(new ChannelHandler[this.metaClientHandlers.size()]));
            }
            try {
                Object result = sessionClient.sendSync(url, request.getRequestBody(), request.getTimeout() != null ? request.getTimeout().intValue() : this.sessionServerConfig.getDataNodeExchangeTimeOut());
                response = () -> result;
            }
            catch (Exception e) {
                url = new URL(this.raftClientManager.refreshLeader().getIp(), this.sessionServerConfig.getMetaServerPort());
                LOGGER.warn("MetaNode Exchanger request send error!It will be retry once!Request url:{}", (Object)url);
                Object result = sessionClient.sendSync(url, request.getRequestBody(), request.getTimeout() != null ? request.getTimeout().intValue() : this.sessionServerConfig.getDataNodeExchangeTimeOut());
                response = () -> result;
            }
        }
        catch (Exception e) {
            LOGGER.error("MetaNode Exchanger request data error!Request url:" + url, (Throwable)e);
            throw new RequestException("MetaNode Exchanger request data error!Request url:" + url, request, (Throwable)e);
        }
        return response;
    }

    public synchronized Client connectServer() {
        Collection nodes = this.metaNodeManager.getDataCenterNodes();
        if (nodes == null || nodes.isEmpty()) {
            this.metaNodeManager.getAllDataCenterNodes();
            nodes = this.metaNodeManager.getDataCenterNodes();
        }
        Client sessionClient = null;
        for (MetaNode node : nodes) {
            URL url;
            block6: {
                url = new URL(node.getIp(), this.sessionServerConfig.getMetaServerPort());
                try {
                    sessionClient = this.boltExchange.getClient("metaServer");
                    if (sessionClient != null) break block6;
                    sessionClient = this.boltExchange.connect("metaServer", url, (Object[])this.metaClientHandlers.toArray(new ChannelHandler[this.metaClientHandlers.size()]));
                }
                catch (Exception e) {
                    LOGGER.error("MetaNode Exchanger connect MetaServer error!url:" + url, (Throwable)e);
                    continue;
                }
            }
            try {
                Channel channel = sessionClient.getChannel(url);
                if (channel != null) continue;
                sessionClient.connect(url);
            }
            catch (Exception e) {
                LOGGER.error("MetaNode Exchanger connect channel error!url:" + url, (Throwable)e);
            }
        }
        return sessionClient;
    }
}

