/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.RenewDatumRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeExchanger.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE");
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Resource(name="dataClientHandlers")
    private Collection<AbstractClientHandler> dataClientHandlers;
    @Autowired
    private NodeManager dataNodeManager;

    public Response request(Request request) throws RequestException {
        Response response;
        URL url = request.getRequestUrl();
        try {
            Object result;
            Client sessionClient = this.getClient(url);
            if (!(request.getRequestBody() instanceof RenewDatumRequest)) {
                EXCHANGE_LOGGER.info("DataNode Exchanger request={},url={}", request.getRequestBody(), (Object)url);
            }
            if ((result = sessionClient.sendSync(url, request.getRequestBody(), request.getTimeout() != null ? request.getTimeout().intValue() : this.sessionServerConfig.getDataNodeExchangeTimeOut())) == null) {
                throw new RequestException("DataNode Exchanger request data get null result!", request);
            }
            response = () -> result;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error when request DataNode! Request url=%s, request=%s, msg=%s", url, request.getRequestBody(), e.getMessage()));
            throw new RequestException("DataNode Exchanger request data error! Request url:" + url, request, (Throwable)e);
        }
        return response;
    }

    public synchronized Client connectServer() {
        Collection dataNodes = this.dataNodeManager.getDataCenterNodes();
        if (dataNodes == null || dataNodes.isEmpty()) {
            this.dataNodeManager.getAllDataCenterNodes();
            dataNodes = this.dataNodeManager.getDataCenterNodes();
        }
        boolean connectedAll = true;
        StringJoiner errorMsg = new StringJoiner(";");
        Client dataClient = null;
        for (Node dataNode : dataNodes) {
            if (dataNode.getNodeUrl() == null || dataNode.getNodeUrl().getIpAddress() == null) {
                LOGGER.error("get data node address error!url{}", (Object)dataNode.getNodeUrl());
                continue;
            }
            URL url = new URL(dataNode.getNodeUrl().getIpAddress(), this.sessionServerConfig.getDataServerPort());
            try {
                dataClient = this.getClient(url);
                dataClient.connect(url);
            }
            catch (Exception e) {
                String msg = "DataNode Exchanger connect DataServer error!url:" + url;
                LOGGER.error(msg, (Throwable)e);
                connectedAll = false;
                errorMsg.add(msg);
            }
        }
        if (!connectedAll) {
            throw new RuntimeException("Data server connected server error: " + errorMsg.toString());
        }
        return dataClient;
    }

    protected Client getClient(URL url) {
        Client sessionClient = this.boltExchange.getClient("dataServer");
        if (sessionClient == null) {
            sessionClient = this.boltExchange.connect("dataServer", this.sessionServerConfig.getDataClientConnNum(), url, (Object[])this.dataClientHandlers.toArray(new ChannelHandler[this.dataClientHandlers.size()]));
        }
        return sessionClient;
    }
}

