/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.provideData.processor;

import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.provideData.ProvideDataProcessor;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.ReSubscribers;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class StopPushProvideDataProcessor
implements ProvideDataProcessor {
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(StopPushProvideDataProcessor.class, (String)"[Task]");
    private static final Logger LOGGER = LoggerFactory.getLogger(StopPushProvideDataProcessor.class);
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private TaskListenerManager taskListenerManager;

    @Override
    public void changeDataProcess(ProvideData provideData) {
        if (provideData != null) {
            if (provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
                LOGGER.info("Fetch session stop push switch no data existed,config not change!");
                return;
            }
            String data = (String)provideData.getProvideData().getObject();
            LOGGER.info("Fetch session stop push data switch {} success!", (Object)data);
            if (data != null) {
                boolean switchData = Boolean.valueOf(data);
                boolean ifChange = this.sessionServerConfig.isStopPushSwitch() != switchData;
                this.sessionServerConfig.setStopPushSwitch(switchData);
                if (!switchData) {
                    if (ifChange) {
                        this.fireReSubscriber();
                    }
                } else {
                    this.sessionServerConfig.setBeginDataFetchTask(false);
                }
            } else {
                LOGGER.error("Fetch session stop push data switch is null!");
            }
            return;
        }
        LOGGER.info("Fetch session stop push switch data null,config not change!");
    }

    private void fireReSubscriber() {
        ReSubscribers reSubscriber;
        Map<String, Map<String, Subscriber>> reSubscribers;
        try {
            this.sessionRegistry.fetchChangDataProcess();
        }
        catch (Throwable e) {
            LOGGER.error("Open push switch first fetch task execute error", e);
        }
        try {
            TimeUnit.MINUTES.sleep(1L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait for dataFetch Task Interrupted!");
        }
        this.sessionServerConfig.setBeginDataFetchTask(true);
        if (this.sessionInterests instanceof ReSubscribers && (reSubscribers = (reSubscriber = (ReSubscribers)((Object)this.sessionInterests)).getReSubscribers()) != null && !reSubscribers.isEmpty()) {
            reSubscribers.forEach((dataInfoId, subscribers) -> this.fireSubscriberMultiFetchTask((String)dataInfoId, subscribers.values()));
            reSubscriber.clearReSubscribers();
        }
    }

    private void fireSubscriberMultiFetchTask(String dataInfoId, Collection<Subscriber> subscribers) {
        if (!CollectionUtils.isEmpty(subscribers)) {
            TaskEvent taskEvent = new TaskEvent((Object)dataInfoId, TaskEvent.TaskType.SUBSCRIBER_MULTI_FETCH_TASK);
            taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
            TASK_LOGGER.info("send " + taskEvent.getTaskType() + " subscribersSize:{},dataInfoId:{}", (Object)subscribers.size(), (Object)dataInfoId);
            this.taskListenerManager.sendTaskEvent(taskEvent);
        }
    }

    @Override
    public void fetchDataProcess(ProvideData provideData) {
        if (provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
            LOGGER.info("Fetch session stop push switch no data existed,config not change!");
            return;
        }
        String data = (String)provideData.getProvideData().getObject();
        this.sessionServerConfig.setStopPushSwitch(Boolean.valueOf(data));
        if (data != null && !Boolean.valueOf(data).booleanValue()) {
            this.sessionServerConfig.setBeginDataFetchTask(true);
        }
        LOGGER.info("Fetch session stop push data switch {} success!", (Object)data);
    }

    @Override
    public boolean support(ProvideData provideData) {
        return "session.stop.push.data.switch#@#9600#@#CONFIG".equals(provideData.getDataInfoId());
    }
}

