/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.provideData.processor;

import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.provideData.ProvideDataProcessor;
import com.alipay.sofa.registry.server.session.registry.Registry;
import org.springframework.beans.factory.annotation.Autowired;

public class RenewSnapshotProvideDataProcessor
implements ProvideDataProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenewSnapshotProvideDataProcessor.class);
    @Autowired
    private Registry sessionRegistry;

    @Override
    public void changeDataProcess(ProvideData provideData) {
        if (provideData == null || provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
            LOGGER.info("Fetch enableDataRenewSnapshot but no data existed, current config not change!");
            return;
        }
        boolean enableDataRenewSnapshot = Boolean.parseBoolean((String)provideData.getProvideData().getObject());
        LOGGER.info("Fetch enableDataRenewSnapshot {} success!", (Object)enableDataRenewSnapshot);
        this.sessionRegistry.setEnableDataRenewSnapshot(enableDataRenewSnapshot);
    }

    @Override
    public void fetchDataProcess(ProvideData provideData) {
        if (provideData == null || provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
            LOGGER.info("Fetch enableDataRenewSnapshot but no data existed, current config not change!");
            return;
        }
        boolean enableDataRenewSnapshot = Boolean.parseBoolean((String)provideData.getProvideData().getObject());
        LOGGER.info("Fetch enableDataRenewSnapshot {} success!", (Object)enableDataRenewSnapshot);
        this.sessionRegistry.setEnableDataRenewSnapshot(enableDataRenewSnapshot);
    }

    @Override
    public boolean support(ProvideData provideData) {
        return "session.enable.datum.renew.switch#@#9600#@#CONFIG".equals(provideData.getDataInfoId());
    }
}

