/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.provideData.processor;

import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistManager;
import com.alipay.sofa.registry.server.session.provideData.ProvideDataProcessor;
import com.alipay.sofa.registry.server.session.registry.Registry;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class BlackListProvideDataProcessor
implements ProvideDataProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackListProvideDataProcessor.class);
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private BlacklistManager blacklistManager;

    @Override
    public void changeDataProcess(ProvideData provideData) {
        if (provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
            LOGGER.info("Fetch session blacklist no data existed,current config not change!");
            return;
        }
        String data = (String)provideData.getProvideData().getObject();
        if (data != null) {
            Map<String, Map<String, Set<String>>> blacklistConfigMap = this.blacklistManager.convertBlacklistConfig(data);
            this.clientOffBlackIp(blacklistConfigMap);
            LOGGER.info("Fetch session blacklist data switch {} success!", (Object)data);
        } else {
            LOGGER.info("Fetch session blacklist data null,current config not change!");
        }
    }

    private void clientOffBlackIp(Map<String, Map<String, Set<String>>> blacklistConfigMap) {
        if (blacklistConfigMap != null) {
            HashSet<String> ipSet = new HashSet<String>();
            for (Map.Entry<String, Map<String, Set<String>>> configEntry : blacklistConfigMap.entrySet()) {
                Map<String, Set<String>> typeMap;
                if (!"FORBIDDEN_PUB".equals(configEntry.getKey()) && !"FORBIDDEN_SUB_BY_PREFIX".equals(configEntry.getKey()) || (typeMap = configEntry.getValue()) == null) continue;
                for (Map.Entry<String, Set<String>> typeEntry : typeMap.entrySet()) {
                    if (!"IP_FULL".equals(typeEntry.getKey()) || typeEntry.getValue() == null) continue;
                    ipSet.addAll((Collection<String>)typeEntry.getValue());
                }
            }
            this.sessionRegistry.remove(this.getIpConnects(ipSet));
        }
    }

    public List<String> getIpConnects(Set<String> _ipList) {
        Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
        ArrayList<String> connections = new ArrayList<String>();
        if (sessionServer != null) {
            Collection channels = sessionServer.getChannels();
            for (Channel channel : channels) {
                String key = NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress());
                String ip = key.substring(0, key.indexOf(":"));
                if (!_ipList.contains(ip)) continue;
                connections.add(key);
            }
        }
        return connections;
    }

    @Override
    public void fetchDataProcess(ProvideData provideData) {
    }

    @Override
    public boolean support(ProvideData provideData) {
        return "session.blacklist.data#@#9600#@#CONFIG".equals(provideData.getDataInfoId());
    }
}

