/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node.service;

import com.alipay.sofa.registry.common.model.metaserver.FetchProvideDataRequest;
import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.alipay.sofa.registry.server.session.node.SessionNodeManager;
import com.alipay.sofa.registry.server.session.node.service.MetaNodeService;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaNodeServiceImpl
implements MetaNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNodeManager.class, (String)"[MetaNodeService]");
    @Autowired
    protected SessionServerConfig sessionServerConfig;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    RaftClientManager raftClientManager;

    @Override
    public ProvideData fetchData(final String dataInfoId) {
        try {
            Request<FetchProvideDataRequest> request = new Request<FetchProvideDataRequest>(){

                public FetchProvideDataRequest getRequestBody() {
                    return new FetchProvideDataRequest(dataInfoId);
                }

                public URL getRequestUrl() {
                    return new URL(MetaNodeServiceImpl.this.raftClientManager.getLeader().getIp(), MetaNodeServiceImpl.this.sessionServerConfig.getMetaServerPort());
                }
            };
            Response response = this.metaNodeExchanger.request((Request)request);
            Object result = response.getResult();
            if (result instanceof ProvideData) {
                return (ProvideData)result;
            }
            LOGGER.error("fetch null provider data!");
            throw new RuntimeException("MetaNodeService fetch null provider data!");
        }
        catch (RequestException e) {
            LOGGER.error("fetch provider data error! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("fetch provider data error! " + e.getMessage(), e);
        }
    }
}

