/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node.service;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.DatumSnapshotRequest;
import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.RenewDatumRequest;
import com.alipay.sofa.registry.common.model.dataserver.ClientOffRequest;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.GetDataRequest;
import com.alipay.sofa.registry.common.model.dataserver.GetDataVersionRequest;
import com.alipay.sofa.registry.common.model.dataserver.PublishDataRequest;
import com.alipay.sofa.registry.common.model.dataserver.UnPublishDataRequest;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.SessionProcessIdGenerator;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private NodeExchanger dataNodeExchanger;
    @Autowired
    private NodeManager dataNodeManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    private AsyncHashedWheelTimer asyncHashedWheelTimer;

    @PostConstruct
    public void init() {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.asyncHashedWheelTimer = new AsyncHashedWheelTimer(threadFactoryBuilder.setNameFormat("Registry-DataNodeServiceImpl-Retry-WheelTimer").build(), 100L, TimeUnit.MILLISECONDS, 1024, this.sessionServerConfig.getDataNodeRetryExecutorThreadSize(), this.sessionServerConfig.getDataNodeRetryExecutorQueueSize(), threadFactoryBuilder.setNameFormat("Registry-DataNodeServiceImpl-Retry-WheelExecutor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
    }

    @Override
    public void register(Publisher publisher) {
        String bizName = "PublishData";
        Request<PublishDataRequest> request = this.buildPublishDataRequest(publisher);
        try {
            this.sendRequest(bizName, request);
        }
        catch (RequestException e) {
            this.doRetryAsync(bizName, request, (Exception)((Object)e), this.sessionServerConfig.getPublishDataTaskRetryTimes(), this.sessionServerConfig.getPublishDataTaskRetryFirstDelay(), this.sessionServerConfig.getPublishDataTaskRetryIncrementDelay());
        }
    }

    private Request<PublishDataRequest> buildPublishDataRequest(final Publisher publisher) {
        return new Request<PublishDataRequest>(){
            private AtomicInteger retryTimes = new AtomicInteger();

            public PublishDataRequest getRequestBody() {
                PublishDataRequest publishDataRequest = new PublishDataRequest();
                publishDataRequest.setPublisher(publisher);
                publishDataRequest.setSessionServerProcessId(SessionProcessIdGenerator.getSessionProcessId());
                return publishDataRequest;
            }

            public URL getRequestUrl() {
                return DataNodeServiceImpl.this.getUrl(publisher.getDataInfoId());
            }

            public AtomicInteger getRetryTimes() {
                return this.retryTimes;
            }
        };
    }

    @Override
    public void unregister(Publisher publisher) {
        String bizName = "UnPublishData";
        Request<UnPublishDataRequest> request = this.buildUnPublishDataRequest(publisher);
        try {
            this.sendRequest(bizName, request);
        }
        catch (RequestException e) {
            this.doRetryAsync(bizName, request, (Exception)((Object)e), this.sessionServerConfig.getUnPublishDataTaskRetryTimes(), this.sessionServerConfig.getUnPublishDataTaskRetryFirstDelay(), this.sessionServerConfig.getUnPublishDataTaskRetryIncrementDelay());
        }
    }

    private Request<UnPublishDataRequest> buildUnPublishDataRequest(final Publisher publisher) {
        return new Request<UnPublishDataRequest>(){
            private AtomicInteger retryTimes = new AtomicInteger();

            public UnPublishDataRequest getRequestBody() {
                UnPublishDataRequest unPublishDataRequest = new UnPublishDataRequest(publisher.getDataInfoId(), publisher.getRegisterId(), publisher.getRegisterTimestamp());
                return unPublishDataRequest;
            }

            public URL getRequestUrl() {
                return DataNodeServiceImpl.this.getUrl(publisher.getDataInfoId());
            }

            public AtomicInteger getRetryTimes() {
                return this.retryTimes;
            }
        };
    }

    @Override
    public void clientOff(List<String> connectIds) {
        if (connectIds == null || connectIds.isEmpty()) {
            return;
        }
        String bizName = "ClientOff";
        Collection nodes = this.dataNodeManager.getDataCenterNodes();
        if (nodes != null && nodes.size() > 0) {
            for (Node node : nodes) {
                Request<ClientOffRequest> request = this.buildClientOffRequest(connectIds, node);
                try {
                    this.sendRequest(bizName, request);
                }
                catch (RequestException e) {
                    this.doRetryAsync(bizName, request, (Exception)((Object)e), this.sessionServerConfig.getCancelDataTaskRetryTimes(), this.sessionServerConfig.getCancelDataTaskRetryFirstDelay(), this.sessionServerConfig.getCancelDataTaskRetryIncrementDelay());
                }
            }
        }
    }

    private Request<ClientOffRequest> buildClientOffRequest(final List<String> connectIds, final Node node) {
        return new Request<ClientOffRequest>(){
            private AtomicInteger retryTimes = new AtomicInteger();

            public ClientOffRequest getRequestBody() {
                ClientOffRequest clientOffRequest = new ClientOffRequest();
                clientOffRequest.setHosts(connectIds);
                clientOffRequest.setGmtOccur(System.currentTimeMillis());
                return clientOffRequest;
            }

            public URL getRequestUrl() {
                return new URL(node.getNodeUrl().getIpAddress(), DataNodeServiceImpl.this.sessionServerConfig.getDataServerPort());
            }

            public AtomicInteger getRetryTimes() {
                return this.retryTimes;
            }
        };
    }

    @Override
    public Map<String, Map<String, Long>> fetchDataVersion(final URL dataNodeUrl, final Collection<String> dataInfoIdList) {
        Map<String, Map<String, Long>> map;
        block4: {
            map = new HashMap();
            try {
                Request<GetDataVersionRequest> getDataVersionRequestRequest = new Request<GetDataVersionRequest>(){

                    public GetDataVersionRequest getRequestBody() {
                        GetDataVersionRequest getDataVersionRequest = new GetDataVersionRequest();
                        getDataVersionRequest.setDataInfoIds((List)dataInfoIdList);
                        return getDataVersionRequest;
                    }

                    public URL getRequestUrl() {
                        return dataNodeUrl;
                    }
                };
                Response response = this.dataNodeExchanger.request((Request)getDataVersionRequestRequest);
                Object result = response.getResult();
                GenericResponse genericResponse = (GenericResponse)result;
                if (genericResponse.isSuccess()) {
                    map = (Map)genericResponse.getData();
                    if (map.isEmpty()) {
                        LOGGER.warn("GetDataVersionRequestRequest get response contains no data!target data Node url:{} about dataInfoIds size:{}", (Object)dataNodeUrl.getAddressString(), (Object)dataInfoIdList.size());
                    }
                    break block4;
                }
                throw new RuntimeException("fetchDataVersion has not get fail response! msg:" + genericResponse.getMessage());
            }
            catch (RequestException e) {
                throw new RuntimeException("Fetch data Version request error! " + e.getMessage(), e);
            }
        }
        return map;
    }

    @Override
    public Datum fetchDataCenter(String dataInfoId, String dataCenterId) {
        Map<String, Datum> map = this.getDatumMap(dataInfoId, dataCenterId);
        if (map != null && map.size() > 0) {
            return map.get(dataCenterId);
        }
        return null;
    }

    @Override
    public Map<String, Datum> fetchGlobal(String dataInfoId) {
        return this.getDatumMap(dataInfoId);
    }

    private Map<String, Datum> getDatumMap(String dataInfoId) {
        return this.getDatumMap(dataInfoId, null);
    }

    @Override
    public Map<String, Datum> getDatumMap(final String dataInfoId, String dataCenterId) {
        Map map;
        block6: {
            try {
                final GetDataRequest getDataRequest = new GetDataRequest();
                if (dataCenterId != null) {
                    getDataRequest.setDataCenter(dataCenterId);
                }
                getDataRequest.setDataInfoId(dataInfoId);
                Request<GetDataRequest> getDataRequestStringRequest = new Request<GetDataRequest>(){

                    public GetDataRequest getRequestBody() {
                        return getDataRequest;
                    }

                    public URL getRequestUrl() {
                        return DataNodeServiceImpl.this.getUrl(dataInfoId);
                    }

                    public Integer getTimeout() {
                        return DataNodeServiceImpl.this.sessionServerConfig.getDataNodeExchangeForFetchDatumTimeOut();
                    }
                };
                Response response = this.dataNodeExchanger.request((Request)getDataRequestStringRequest);
                Object result = response.getResult();
                GenericResponse genericResponse = (GenericResponse)result;
                if (genericResponse.isSuccess()) {
                    map = (Map)genericResponse.getData();
                    if (map == null || map.isEmpty()) {
                        LOGGER.warn("GetDataRequest get response contains no datum!dataInfoId={}", (Object)dataInfoId);
                    } else {
                        map.forEach((dataCenter, datum) -> Datum.internDatum((Datum)datum));
                    }
                    break block6;
                }
                throw new RuntimeException(String.format("GetDataRequest has got fail response!dataInfoId:%s msg:%s", dataInfoId, genericResponse.getMessage()));
            }
            catch (RequestException e) {
                throw new RuntimeException(String.format("Get data request to data node error!dataInfoId:%s msg:%s ", dataInfoId, e.getMessage()), e);
            }
        }
        return map;
    }

    @Override
    public Boolean renewDatum(RenewDatumRequest renewDatumRequest) {
        Request<RenewDatumRequest> request = this.buildRenewDatumRequest(renewDatumRequest);
        try {
            GenericResponse genericResponse = (GenericResponse)this.sendRequest("RenewDatum", request);
            return (Boolean)genericResponse.getData();
        }
        catch (RequestException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Request<RenewDatumRequest> buildRenewDatumRequest(final RenewDatumRequest renewDatumRequest) {
        return new Request<RenewDatumRequest>(){
            private AtomicInteger retryTimes = new AtomicInteger();

            public RenewDatumRequest getRequestBody() {
                return renewDatumRequest;
            }

            public URL getRequestUrl() {
                return new URL(renewDatumRequest.getDataServerIP(), DataNodeServiceImpl.this.sessionServerConfig.getDataServerPort());
            }

            public AtomicInteger getRetryTimes() {
                return this.retryTimes;
            }
        };
    }

    @Override
    public void sendDatumSnapshot(DatumSnapshotRequest datumSnapshotRequest) {
        String bizName = "DatumSnapshot";
        Request<DatumSnapshotRequest> request = this.buildDatumSnapshotRequest(datumSnapshotRequest);
        try {
            this.sendRequest(bizName, request);
        }
        catch (RequestException e) {
            this.doRetryAsync(bizName, request, (Exception)((Object)e), this.sessionServerConfig.getDatumSnapshotTaskRetryTimes(), this.sessionServerConfig.getDatumSnapshotTaskRetryFirstDelay(), this.sessionServerConfig.getDatumSnapshotTaskRetryIncrementDelay());
        }
    }

    private Request<DatumSnapshotRequest> buildDatumSnapshotRequest(final DatumSnapshotRequest datumSnapshotRequest) {
        return new Request<DatumSnapshotRequest>(){
            private AtomicInteger retryTimes = new AtomicInteger();

            public DatumSnapshotRequest getRequestBody() {
                return datumSnapshotRequest;
            }

            public URL getRequestUrl() {
                return new URL(datumSnapshotRequest.getDataServerIp(), DataNodeServiceImpl.this.sessionServerConfig.getDataServerPort());
            }

            public AtomicInteger getRetryTimes() {
                return this.retryTimes;
            }
        };
    }

    private CommonResponse sendRequest(String bizName, Request request) throws RequestException {
        Response response = this.dataNodeExchanger.request(request);
        Object result = response.getResult();
        CommonResponse commonResponse = (CommonResponse)result;
        if (!commonResponse.isSuccess()) {
            throw new RuntimeException(String.format("[%s] response not success, failed! target url: %s, request: %s, message: %s", bizName, request.getRequestUrl(), request.getRequestBody(), commonResponse.getMessage()));
        }
        return commonResponse;
    }

    private void doRetryAsync(String bizName, Request request, Exception e, int maxRetryTimes, long firstDelay, long incrementDelay) {
        int retryTimes = request.getRetryTimes().incrementAndGet();
        if (retryTimes <= maxRetryTimes) {
            LOGGER.warn("{} failed, will retry again, retryTimes: {}, msg: {}", new Object[]{bizName, retryTimes, e.getMessage()});
            this.asyncHashedWheelTimer.newTimeout(timeout -> {
                try {
                    this.sendRequest(bizName, request);
                }
                catch (RequestException ex) {
                    this.doRetryAsync(bizName, request, (Exception)((Object)ex), maxRetryTimes, firstDelay, incrementDelay);
                }
            }, this.getDelayTime(retryTimes, firstDelay, incrementDelay), TimeUnit.MILLISECONDS);
        } else {
            LOGGER.error(String.format("%s failed, retryTimes have exceeded! stop retry! retryTimes: %s, url: %s, request: %s, msg: %s", bizName, retryTimes - 1, request.getRequestUrl(), request.getRequestBody(), e.getMessage()), (Throwable)e);
        }
    }

    private long getDelayTime(int retry, long firstDelay, long incrementDelay) {
        long increment;
        long initialSleepTime = TimeUnit.MILLISECONDS.toMillis(firstDelay);
        long result = initialSleepTime + (increment = TimeUnit.MILLISECONDS.toMillis(incrementDelay)) * (long)(retry - 1);
        return result >= 0L ? result : 0L;
    }

    private URL getUrl(String dataInfoId) {
        Object dataNode = this.dataNodeManager.getNode(dataInfoId);
        String dataIp = dataNode.getNodeUrl().getIpAddress();
        return new URL(dataIp, this.sessionServerConfig.getDataServerPort());
    }
}

