/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.GetNodesRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.alipay.sofa.registry.util.VersionsMapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNodeManager<T extends Node>
implements NodeManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNodeManager.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE");
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock read = this.readWriteLock.readLock();
    protected final Lock write = this.readWriteLock.writeLock();
    protected Map<String, Map<String, T>> nodes = new ConcurrentHashMap<String, Map<String, T>>();
    @Autowired
    protected SessionServerConfig sessionServerConfig;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    protected RaftClientManager raftClientManager;
    private ConcurrentHashMap<String, Long> dataCenterNodesVersions = new ConcurrentHashMap();

    @Override
    public Collection<T> getDataCenterNodes() {
        this.read.lock();
        try {
            Map<String, T> dataMap = this.nodes.get(this.sessionServerConfig.getSessionServerDataCenter());
            if (dataMap != null) {
                Collection<T> collection = dataMap.values();
                return collection;
            }
        }
        finally {
            this.read.unlock();
        }
        return new ArrayList();
    }

    @Override
    public Collection<String> getDataCenters() {
        this.read.lock();
        try {
            Set<String> set = this.nodes.keySet();
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void updateNodes(NodeChangeResult nodeChangeResult) {
        this.write.lock();
        try {
            this.nodes = nodeChangeResult.getNodes();
            this.dataCenterNodesVersions.putIfAbsent(nodeChangeResult.getLocalDataCenter(), nodeChangeResult.getVersion());
        }
        finally {
            this.write.unlock();
        }
    }

    public boolean checkAndUpdateListVersions(String dataCenterId, Long version) {
        return VersionsMapUtils.checkAndUpdateVersions(this.dataCenterNodesVersions, (String)dataCenterId, (Long)version);
    }

    @Override
    public NodeChangeResult getAllDataCenterNodes() {
        NodeChangeResult nodeChangeResult;
        try {
            Request<GetNodesRequest> getNodesRequestRequest = new Request<GetNodesRequest>(){

                public GetNodesRequest getRequestBody() {
                    return new GetNodesRequest(AbstractNodeManager.this.getNodeType());
                }

                public URL getRequestUrl() {
                    return new URL(AbstractNodeManager.this.raftClientManager.getLeader().getIp(), AbstractNodeManager.this.sessionServerConfig.getMetaServerPort());
                }
            };
            Response response = this.metaNodeExchanger.request((Request)getNodesRequestRequest);
            if (response == null || response.getResult() == null) {
                LOGGER.error("NodeManager get all dataCenter nodes type {} error!No response receive!", (Object)this.getNodeType());
                throw new RuntimeException("NodeManager get all dataCenter nodes error!No response receive!");
            }
            nodeChangeResult = (NodeChangeResult)response.getResult();
            this.updateNodes(nodeChangeResult);
            EXCHANGE_LOGGER.info("Update node type {} success!info:{}", (Object)this.getNodeType(), (Object)nodeChangeResult.getNodes());
        }
        catch (RequestException e) {
            LOGGER.error("NodeManager get all dataCenter nodes error! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("NodeManager get all dataCenter nodes error! " + e.getMessage(), e);
        }
        return nodeChangeResult;
    }

    @Override
    public ConcurrentHashMap<String, Long> getDataCenterNodesVersions() {
        return this.dataCenterNodesVersions;
    }
}

