/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.listener;

import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.ReceivedConfigDataPushTask;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.server.session.strategy.ReceivedConfigDataPushTaskStrategy;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListener;
import org.springframework.beans.factory.annotation.Autowired;

public class ReceivedConfigDataPushTaskListener
implements TaskListener {
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private ClientNodeService clientNodeService;
    @Autowired
    private ReceivedConfigDataPushTaskStrategy receivedConfigDataPushTaskStrategy;
    private volatile TaskDispatcher<String, SessionTask> singleTaskDispatcher;
    private TaskProcessor clientNodeSingleTaskProcessor;

    public ReceivedConfigDataPushTaskListener(TaskProcessor clientNodeSingleTaskProcessor) {
        this.clientNodeSingleTaskProcessor = clientNodeSingleTaskProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDispatcher<String, SessionTask> getSingleTaskDispatcher() {
        if (this.singleTaskDispatcher == null) {
            ReceivedConfigDataPushTaskListener receivedConfigDataPushTaskListener = this;
            synchronized (receivedConfigDataPushTaskListener) {
                if (this.singleTaskDispatcher == null) {
                    this.singleTaskDispatcher = TaskDispatchers.createDefaultSingleTaskDispatcher((String)TaskEvent.TaskType.RECEIVED_DATA_CONFIG_PUSH_TASK.getName(), (TaskProcessor)this.clientNodeSingleTaskProcessor);
                }
            }
        }
        return this.singleTaskDispatcher;
    }

    public TaskEvent.TaskType support() {
        return TaskEvent.TaskType.RECEIVED_DATA_CONFIG_PUSH_TASK;
    }

    public void handleEvent(TaskEvent event) {
        ReceivedConfigDataPushTask receivedConfigDataPushTask = new ReceivedConfigDataPushTask(this.sessionServerConfig, this.clientNodeService, this.receivedConfigDataPushTaskStrategy);
        receivedConfigDataPushTask.setTaskEvent(event);
        this.getSingleTaskDispatcher().dispatch((Object)receivedConfigDataPushTask.getTaskId(), (Object)receivedConfigDataPushTask, receivedConfigDataPushTask.getExpiryTime());
    }
}

