/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.filter.blacklist;

import com.alipay.sofa.registry.server.session.filter.IPMatchStrategy;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistManager;
import com.alipay.sofa.registry.server.session.filter.blacklist.MatchType;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultIPMatchStrategy
implements IPMatchStrategy<String> {
    @Autowired
    private BlacklistManager blacklistManager;

    @Override
    public boolean match(String IP, Supplier<String> getOperatorType) {
        return this.match(getOperatorType.get(), IP);
    }

    private boolean match(String type, String matchPattern) {
        List<BlacklistConfig> configList = this.blacklistManager.getBlacklistConfigList();
        for (BlacklistConfig blacklistConfig : configList) {
            List<MatchType> matchTypeList;
            if (!StringUtils.equals((String)type, (String)blacklistConfig.getType()) || null == (matchTypeList = blacklistConfig.getMatchTypes()) || matchTypeList.size() == 0) continue;
            for (MatchType matchType : matchTypeList) {
                Set patterns;
                if (null == matchType || !"IP_FULL".equals(matchType.getType()) || null == (patterns = matchType.getPatternSet()) || patterns.size() == 0 || !patterns.contains(matchPattern)) continue;
                return true;
            }
        }
        return false;
    }
}

