/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.filter.blacklist;

import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.filter.DataIdMatchStrategy;
import com.alipay.sofa.registry.server.session.filter.IPMatchStrategy;
import com.alipay.sofa.registry.server.session.filter.ProcessFilter;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BlacklistMatchProcessFilter
implements ProcessFilter<BaseInfo> {
    @Autowired
    private DataIdMatchStrategy dataIdMatchStrategy;
    @Autowired
    private IPMatchStrategy ipMatchStrategy;
    @Autowired
    private BlacklistManager blacklistManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;

    @Override
    public boolean match(BaseInfo storeData) {
        List<BlacklistConfig> configList = this.blacklistManager.getBlacklistConfigList();
        if (null == configList || configList.size() == 0) {
            return false;
        }
        URL url = storeData.getSourceAddress();
        if (url != null) {
            switch (storeData.getDataType()) {
                case PUBLISHER: {
                    if (this.dataIdMatchStrategy.match(storeData.getDataId(), () -> this.sessionServerConfig.getBlacklistPubDataIdRegex())) {
                        return this.ipMatchStrategy.match(url.getIpAddress(), () -> "FORBIDDEN_PUB");
                    }
                }
                case SUBSCRIBER: {
                    if (!this.dataIdMatchStrategy.match(storeData.getDataId(), () -> this.sessionServerConfig.getBlacklistSubDataIdRegex())) break;
                    return this.ipMatchStrategy.match(url.getIpAddress(), () -> "FORBIDDEN_SUB_BY_PREFIX");
                }
            }
            return false;
        }
        return false;
    }

    public DataIdMatchStrategy getDataIdMatchStrategy() {
        return this.dataIdMatchStrategy;
    }

    public void setDataIdMatchStrategy(DataIdMatchStrategy dataIdMatchStrategy) {
        this.dataIdMatchStrategy = dataIdMatchStrategy;
    }

    public IPMatchStrategy getIpMatchStrategy() {
        return this.ipMatchStrategy;
    }

    public void setIpMatchStrategy(IPMatchStrategy ipMatchStrategy) {
        this.ipMatchStrategy = ipMatchStrategy;
    }

    public BlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    public void setBlacklistManager(BlacklistManager blacklistManager) {
        this.blacklistManager = blacklistManager;
    }
}

