/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.filter.blacklist;

import com.alipay.sofa.registry.common.model.metaserver.FetchProvideDataRequest;
import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistManager;
import com.alipay.sofa.registry.server.session.filter.blacklist.MatchType;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class BlacklistManagerImpl
implements BlacklistManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlacklistManagerImpl.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE");
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    protected RaftClientManager raftClientManager;
    private List<BlacklistConfig> blacklistConfigList = new ArrayList<BlacklistConfig>();

    @Override
    public void load() {
        this.fetchStopPushSwitch();
    }

    @Override
    public List<BlacklistConfig> getBlacklistConfigList() {
        return this.blacklistConfigList;
    }

    @Override
    public void setBlacklistConfigList(List<BlacklistConfig> blacklistConfigList) {
        this.blacklistConfigList = blacklistConfigList;
    }

    private void fetchStopPushSwitch() {
        Object ret = this.sendMetaRequest();
        if (ret instanceof ProvideData) {
            ProvideData provideData = (ProvideData)ret;
            if (provideData.getProvideData() == null || provideData.getProvideData().getObject() == null) {
                LOGGER.info("Fetch session blacklist no data existed,current config not change!");
                return;
            }
            String data = (String)provideData.getProvideData().getObject();
            if (data != null) {
                this.convertBlacklistConfig(data);
                EXCHANGE_LOGGER.info("Fetch session blacklist data switch {} success!", (Object)data);
            } else {
                LOGGER.info("Fetch session blacklist data null,current config not change!");
            }
        } else {
            LOGGER.info("Fetch session blacklist data null,config not change!");
        }
    }

    private Object sendMetaRequest() {
        try {
            Request<FetchProvideDataRequest> request = new Request<FetchProvideDataRequest>(){

                public FetchProvideDataRequest getRequestBody() {
                    return new FetchProvideDataRequest("session.blacklist.data#@#9600#@#CONFIG");
                }

                public URL getRequestUrl() {
                    return new URL(BlacklistManagerImpl.this.raftClientManager.getLeader().getIp(), BlacklistManagerImpl.this.sessionServerConfig.getMetaServerPort());
                }
            };
            Response response = this.metaNodeExchanger.request((Request)request);
            if (response != null && response.getResult() != null) {
                EXCHANGE_LOGGER.info("Update blacklist info success!");
                return response.getResult();
            }
            LOGGER.error("Get blacklist info error!No response receive!");
            throw new RuntimeException("Get blacklist info error!No response receive!");
        }
        catch (Exception e) {
            LOGGER.error("Get blacklist info error!", (Throwable)e);
            throw new RuntimeException("Get blacklist info error! ", e);
        }
    }

    @Override
    public Map<String, Map<String, Set<String>>> convertBlacklistConfig(String config) {
        Map blacklistConfigMap;
        TypeReference<HashMap<String, HashMap<String, HashSet<String>>>> typeReference = new TypeReference<HashMap<String, HashMap<String, HashSet<String>>>>(){};
        ObjectMapper mapper = new ObjectMapper();
        try {
            blacklistConfigMap = (Map)mapper.readValue(config, (TypeReference)typeReference);
        }
        catch (IOException e) {
            LOGGER.error("Parser config json error!", (Throwable)e);
            return null;
        }
        if (null == blacklistConfigMap) {
            LOGGER.info("[cmd] setBlacklistConfig fail, params is null");
            return null;
        }
        try {
            ArrayList<BlacklistConfig> blacklistConfigs = new ArrayList<BlacklistConfig>();
            for (Map.Entry configEntry : blacklistConfigMap.entrySet()) {
                BlacklistConfig blacklistConfig = new BlacklistConfig();
                blacklistConfig.setType((String)configEntry.getKey());
                ArrayList<MatchType> matchTypeList = new ArrayList<MatchType>();
                Map matchTypeMap = (Map)configEntry.getValue();
                for (Map.Entry typeEntry : matchTypeMap.entrySet()) {
                    String type = (String)typeEntry.getKey();
                    MatchType ipFullMatchType = new MatchType();
                    ipFullMatchType.setType(type);
                    ipFullMatchType.setPatternSet((Set)typeEntry.getValue());
                    matchTypeList.add(ipFullMatchType);
                }
                blacklistConfig.setMatchTypes(matchTypeList);
                blacklistConfigs.add(blacklistConfig);
            }
            this.setBlacklistConfigList(blacklistConfigs);
            return blacklistConfigMap;
        }
        catch (Exception e) {
            LOGGER.error("[cmd] setBlacklistConfig error", (Throwable)e);
            return null;
        }
    }
}

