/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.converter;

import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.converter.ScopeEnumConverter;
import com.alipay.sofa.registry.core.model.ConfiguratorRegister;
import com.alipay.sofa.registry.core.model.SubscriberRegister;
import com.alipay.sofa.registry.server.session.converter.Converter;

public class SubscriberConverter {
    public static Subscriber convert(SubscriberRegister subscriberRegister) {
        Converter<SubscriberRegister, Subscriber> converter = source -> {
            Subscriber subscriber = new Subscriber();
            subscriber.setAppName(source.getAppName());
            subscriber.setCell(source.getZone());
            subscriber.setClientId(source.getClientId());
            subscriber.setDataId(source.getDataId());
            subscriber.setGroup(source.getGroup());
            subscriber.setInstanceId(source.getInstanceId());
            subscriber.setRegisterId(source.getRegistId());
            subscriber.setProcessId(source.getProcessId());
            subscriber.setVersion(source.getVersion());
            subscriber.setRegisterTimestamp(System.currentTimeMillis());
            subscriber.setClientRegisterTimestamp(source.getTimestamp().longValue());
            subscriber.setScope(ScopeEnumConverter.convertToScope((String)source.getScope()));
            subscriber.setSourceAddress(new URL(source.getIp(), source.getPort().intValue()));
            subscriber.setClientVersion(BaseInfo.ClientVersion.StoreData);
            DataInfo dataInfo = new DataInfo(source.getInstanceId(), source.getDataId(), source.getGroup());
            subscriber.setDataInfoId(dataInfo.getDataInfoId());
            return subscriber;
        };
        return converter.convert(subscriberRegister);
    }

    public static Watcher convert(ConfiguratorRegister configuratorRegister) {
        Converter<ConfiguratorRegister, Watcher> converter = source -> {
            Watcher watcher = new Watcher();
            watcher.setAppName(source.getAppName());
            watcher.setCell(source.getZone());
            watcher.setClientId(source.getClientId());
            watcher.setDataId(source.getDataId());
            watcher.setGroup(source.getGroup());
            watcher.setInstanceId(source.getInstanceId());
            watcher.setRegisterId(source.getRegistId());
            watcher.setProcessId(source.getProcessId());
            watcher.setVersion(source.getVersion());
            watcher.setRegisterTimestamp(source.getTimestamp().longValue());
            watcher.setSourceAddress(new URL(source.getIp(), source.getPort().intValue()));
            watcher.setClientVersion(BaseInfo.ClientVersion.StoreData);
            DataInfo dataInfo = new DataInfo(source.getInstanceId(), source.getDataId(), source.getGroup());
            watcher.setDataInfoId(dataInfo.getDataInfoId());
            return watcher;
        };
        return converter.convert(configuratorRegister);
    }
}

