/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.bootstrap;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerBootstrap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;

public class SessionServerInitializer
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionServerInitializer.class);
    @Autowired
    private SessionServerBootstrap sessionServerBootstrap;
    private AtomicBoolean running = new AtomicBoolean(false);

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        try {
            this.sessionServerBootstrap.start();
            LOGGER.info("Started SessionServer");
            this.running.set(true);
        }
        catch (Exception ex) {
            this.running.set(false);
            LOGGER.error("Could not initialize Session server!", (Throwable)ex);
        }
    }

    public void stop() {
        this.running.set(false);
        this.sessionServerBootstrap.destroy();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void stop(Runnable callback) {
        callback.run();
        this.running.set(false);
    }
}

