/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.bootstrap;

import com.alipay.sofa.registry.common.model.metaserver.FetchProvideDataRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.filter.blacklist.BlacklistManager;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.NodeManagerFactory;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.alipay.sofa.registry.server.session.node.SessionProcessIdGenerator;
import com.alipay.sofa.registry.server.session.provideData.ProvideDataProcessor;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class SessionServerBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionServerBootstrap.class);
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private Exchange jerseyExchange;
    @Autowired
    private ExecutorManager executorManager;
    @Resource(name="serverHandlers")
    private Collection<AbstractServerHandler> serverHandlers;
    @Autowired
    private NodeManager metaNodeManager;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    private NodeExchanger dataNodeExchanger;
    @Autowired
    private ResourceConfig jerseyResourceConfig;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RaftClientManager raftClientManager;
    @Autowired
    private BlacklistManager blacklistManager;
    @Autowired
    private ProvideDataProcessor provideDataProcessorManager;
    private Server server;
    private Server httpServer;
    private Client metaClient;
    private AtomicBoolean metaStart = new AtomicBoolean(false);
    private AtomicBoolean schedulerStart = new AtomicBoolean(false);
    private AtomicBoolean httpStart = new AtomicBoolean(false);
    private AtomicBoolean serverStart = new AtomicBoolean(false);
    private AtomicBoolean dataStart = new AtomicBoolean(false);

    public void start() {
        try {
            LOGGER.info("the configuration items are as follows: " + this.sessionServerConfig.toString());
            this.initEnvironment();
            this.startRaftClient();
            this.connectMetaServer();
            this.startScheduler();
            this.openHttpServer();
            this.openSessionServer();
            this.connectDataServer();
            LOGGER.info("Initialized Session Server...");
            Runtime.getRuntime().addShutdownHook(new Thread(this::doStop));
        }
        catch (Throwable e) {
            LOGGER.error("Cannot bootstrap session server :", e);
            throw new RuntimeException("Cannot bootstrap session server :", e);
        }
    }

    public void destroy() {
        this.doStop();
    }

    private void doStop() {
        try {
            LOGGER.info("{} Shutting down Session Server..", (Object)new Date().toString());
            this.executorManager.stopScheduler();
            TaskDispatchers.stopDefaultSingleTaskDispatcher();
            this.stopHttpServer();
            this.stopServer();
        }
        catch (Throwable e) {
            LOGGER.error("Shutting down Session Server error!", e);
        }
        LOGGER.info("{} Session server is now shutdown...", (Object)new Date().toString());
    }

    private void initEnvironment() {
        LOGGER.info("Session server Environment: DataCenter {},Region {},ProcessId {}", new Object[]{this.sessionServerConfig.getSessionServerDataCenter(), this.sessionServerConfig.getSessionServerRegion(), SessionProcessIdGenerator.getSessionProcessId()});
    }

    private void startScheduler() {
        try {
            if (this.schedulerStart.compareAndSet(false, true)) {
                this.executorManager.startScheduler();
                LOGGER.info("Session Scheduler started!");
            }
        }
        catch (Exception e) {
            this.schedulerStart.set(false);
            LOGGER.error("Session Scheduler start error!", (Throwable)e);
            throw new RuntimeException("Session Scheduler start error!", e);
        }
    }

    private void openSessionServer() {
        try {
            if (this.serverStart.compareAndSet(false, true)) {
                this.server = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.sessionServerConfig.getServerPort()), (Object[])this.serverHandlers.toArray(new ChannelHandler[this.serverHandlers.size()]));
                LOGGER.info("Session server started! port:{}", (Object)this.sessionServerConfig.getServerPort());
            }
        }
        catch (Exception e) {
            this.serverStart.set(false);
            LOGGER.error("Session server start error! port:{}", (Object)this.sessionServerConfig.getServerPort(), (Object)e);
            throw new RuntimeException("Session server start error!", e);
        }
    }

    private void connectDataServer() {
        try {
            if (this.dataStart.compareAndSet(false, true)) {
                this.dataNodeExchanger.connectServer();
            }
        }
        catch (Exception e) {
            this.dataStart.set(false);
            LOGGER.error("Data server connected server error! port:{}", (Object)this.sessionServerConfig.getDataServerPort(), (Object)e);
            throw new RuntimeException("Data server connected server error!", e);
        }
    }

    private void startRaftClient() {
        this.raftClientManager.startRaftClient();
        LOGGER.info("Raft Client started! Leader:{}", (Object)this.raftClientManager.getLeader());
    }

    private void connectMetaServer() {
        try {
            if (this.metaStart.compareAndSet(false, true)) {
                this.metaClient = this.metaNodeExchanger.connectServer();
                URL leaderUrl = new URL(this.raftClientManager.getLeader().getIp(), this.sessionServerConfig.getMetaServerPort());
                this.registerSessionNode(leaderUrl);
                this.getAllDataCenter();
                this.fetchStopPushSwitch(leaderUrl);
                this.fetchEnableDataRenewSnapshot(leaderUrl);
                this.fetchBlackList();
                LOGGER.info("MetaServer connected meta server! Port:{}", (Object)this.sessionServerConfig.getMetaServerPort());
            }
        }
        catch (Exception e) {
            this.metaStart.set(false);
            LOGGER.error("MetaServer connected server error! Port:{}", (Object)this.sessionServerConfig.getMetaServerPort(), (Object)e);
            throw new RuntimeException("MetaServer connected server error!", e);
        }
    }

    private void registerSessionNode(URL leaderUrl) {
        URL clientUrl = new URL(NetUtil.getLocalAddress().getHostAddress(), 0);
        SessionNode sessionNode = new SessionNode(clientUrl, this.sessionServerConfig.getSessionServerRegion());
        Object ret = this.sendMetaRequest(sessionNode, leaderUrl);
        if (ret instanceof NodeChangeResult) {
            NodeChangeResult nodeChangeResult = (NodeChangeResult)ret;
            NodeManager nodeManager = NodeManagerFactory.getNodeManager(nodeChangeResult.getNodeType());
            nodeManager.updateNodes(nodeChangeResult);
            LOGGER.info("Register MetaServer Session Node success!get data node list {}", (Object)nodeChangeResult.getNodes());
        }
    }

    private void fetchStopPushSwitch(URL leaderUrl) {
        FetchProvideDataRequest fetchProvideDataRequest = new FetchProvideDataRequest("session.stop.push.data.switch#@#9600#@#CONFIG");
        Object ret = this.sendMetaRequest(fetchProvideDataRequest, leaderUrl);
        if (ret instanceof ProvideData) {
            ProvideData provideData = (ProvideData)ret;
            this.provideDataProcessorManager.fetchDataProcess(provideData);
        } else {
            LOGGER.info("Fetch session stop push switch data null,config not change!");
        }
    }

    private void fetchEnableDataRenewSnapshot(URL leaderUrl) {
        FetchProvideDataRequest fetchProvideDataRequest = new FetchProvideDataRequest("session.enable.datum.renew.switch#@#9600#@#CONFIG");
        Object data = this.sendMetaRequest(fetchProvideDataRequest, leaderUrl);
        if (data instanceof ProvideData) {
            ProvideData provideData = (ProvideData)data;
            this.provideDataProcessorManager.fetchDataProcess(provideData);
        }
    }

    private void fetchBlackList() {
        this.blacklistManager.load();
    }

    private Object sendMetaRequest(Object request, URL leaderUrl) {
        Object ret;
        try {
            ret = this.metaClient.sendSync(leaderUrl, request, this.sessionServerConfig.getMetaNodeExchangeTimeOut());
        }
        catch (Exception e) {
            URL leaderUrlNew = new URL(this.raftClientManager.refreshLeader().getIp(), this.sessionServerConfig.getMetaServerPort());
            LOGGER.warn("request send error!It will be retry once to new leader {}!", (Object)leaderUrlNew);
            ret = this.metaClient.sendSync(leaderUrlNew, request, this.sessionServerConfig.getMetaNodeExchangeTimeOut());
        }
        return ret;
    }

    private void getAllDataCenter() {
        this.metaNodeManager.getAllDataCenterNodes();
        LOGGER.info("Get all dataCenter from meta Server success!");
    }

    private void openHttpServer() {
        try {
            if (this.httpStart.compareAndSet(false, true)) {
                this.bindResourceConfig();
                this.httpServer = this.jerseyExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.sessionServerConfig.getHttpServerPort()), (Object[])new ResourceConfig[]{this.jerseyResourceConfig});
                LOGGER.info("Open http server port {} success!", (Object)this.sessionServerConfig.getHttpServerPort());
            }
        }
        catch (Exception e) {
            LOGGER.error("Open http server port {} error!", (Object)this.sessionServerConfig.getHttpServerPort(), (Object)e);
            this.httpStart.set(false);
            throw new RuntimeException("Open http server error!", e);
        }
    }

    private void bindResourceConfig() {
        this.registerInstances(Path.class);
        this.registerInstances(Provider.class);
    }

    private void registerInstances(Class<? extends Annotation> annotationType) {
        Map beans = this.applicationContext.getBeansWithAnnotation(annotationType);
        if (beans != null && !beans.isEmpty()) {
            beans.forEach((beanName, bean) -> {
                this.jerseyResourceConfig.registerInstances(new Object[]{bean});
                this.jerseyResourceConfig.register(bean.getClass());
            });
        }
    }

    private void stopServer() {
        if (this.server != null && this.server.isOpen()) {
            this.server.close();
        }
    }

    private void stopHttpServer() {
        if (this.httpServer != null && this.httpServer.isOpen()) {
            this.httpServer.close();
        }
    }

    public AtomicBoolean getMetaStart() {
        return this.metaStart;
    }

    public AtomicBoolean getSchedulerStart() {
        return this.schedulerStart;
    }

    public AtomicBoolean getHttpStart() {
        return this.httpStart;
    }

    public AtomicBoolean getServerStart() {
        return this.serverStart;
    }

    public AtomicBoolean getDataStart() {
        return this.dataStart;
    }
}

