/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.acceptor;

import com.alipay.sofa.registry.server.session.acceptor.WriteDataAcceptor;
import com.alipay.sofa.registry.server.session.acceptor.WriteDataProcessor;
import com.alipay.sofa.registry.server.session.acceptor.WriteDataRequest;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.renew.RenewService;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class WriteDataAcceptorImpl
implements WriteDataAcceptor {
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private RenewService renewService;
    private Map<String, WriteDataProcessor> writeDataProcessors = new ConcurrentHashMap<String, WriteDataProcessor>();

    @Override
    public void accept(WriteDataRequest request) {
        String connectId = request.getConnectId();
        WriteDataProcessor writeDataProcessor = this.writeDataProcessors.computeIfAbsent(connectId, key -> new WriteDataProcessor(connectId, this.taskListenerManager, this.sessionServerConfig, this.renewService));
        writeDataProcessor.process(request);
    }

    @Override
    public void remove(String connectId) {
        this.writeDataProcessors.remove(connectId);
    }
}

