/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.resource;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.NodeManagerFactory;
import com.alipay.sofa.registry.server.session.node.SessionNodeManager;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="api/servers")
public class SessionOpenResource {
    @Autowired
    private SessionServerConfig sessionServerConfig;

    @GET
    @Path(value="query.json")
    @Produces(value={"application/json"})
    public List<String> getSessionServerListJson(@QueryParam(value="zone") String zone) {
        List<String> serverList = new ArrayList<String>();
        NodeManager nodeManager = NodeManagerFactory.getNodeManager(Node.NodeType.SESSION);
        if (StringUtils.isEmpty((String)zone)) {
            zone = this.sessionServerConfig.getSessionServerRegion();
        }
        if (StringUtils.isNotBlank((String)zone)) {
            zone = zone.toUpperCase();
        }
        if (nodeManager instanceof SessionNodeManager) {
            SessionNodeManager sessionNodeManager = (SessionNodeManager)nodeManager;
            serverList = sessionNodeManager.getZoneServerList(zone);
            serverList = serverList.stream().map(server -> server + ":" + this.sessionServerConfig.getServerPort()).collect(Collectors.toList());
        }
        return serverList;
    }

    @GET
    @Path(value="query")
    @Produces(value={"text/plain"})
    public String getSessionServerList(@QueryParam(value="zone") String zone) {
        return Joiner.on((String)";").join(this.getSessionServerListJson(zone));
    }

    @GET
    @Path(value="alive")
    public String checkAlive() {
        return "OK";
    }
}

