/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.listener;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.listener.PushTaskSender;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.ReceivedDataMultiPushTask;
import com.alipay.sofa.registry.server.session.strategy.ReceivedDataMultiPushTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.TaskMergeProcessorStrategy;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListener;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class ReceivedDataMultiPushTaskListener
implements TaskListener,
PushTaskSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedDataMultiPushTaskListener.class);
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private ClientNodeService clientNodeService;
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy;
    private TaskMergeProcessorStrategy receiveDataTaskMergeProcessorStrategy;
    private TaskProcessor clientNodeSingleTaskProcessor;
    private AsyncHashedWheelTimer asyncHashedWheelTimer;

    public ReceivedDataMultiPushTaskListener(TaskProcessor clientNodeSingleTaskProcessor, TaskMergeProcessorStrategy receiveDataTaskMergeProcessorStrategy, SessionServerConfig sessionServerConfig) {
        this.clientNodeSingleTaskProcessor = clientNodeSingleTaskProcessor;
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.asyncHashedWheelTimer = new AsyncHashedWheelTimer(threadFactoryBuilder.setNameFormat("Registry-ReceivedDataPushTask-WheelTimer").build(), (long)sessionServerConfig.getUserDataPushRetryWheelTicksDuration(), TimeUnit.MILLISECONDS, sessionServerConfig.getUserDataPushRetryWheelTicksSize(), threadFactoryBuilder.setNameFormat("Registry-ReceivedDataPushTask-WheelExecutor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
        receiveDataTaskMergeProcessorStrategy.init(this);
        this.receiveDataTaskMergeProcessorStrategy = receiveDataTaskMergeProcessorStrategy;
    }

    public boolean support(TaskEvent event) {
        return TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK.equals((Object)event.getTaskType());
    }

    public void handleEvent(TaskEvent event) {
        this.receiveDataTaskMergeProcessorStrategy.handleEvent(event);
    }

    @Override
    public void executePushAsync(TaskEvent event) {
        ReceivedDataMultiPushTask receivedDataMultiPushTask = new ReceivedDataMultiPushTask(this.sessionServerConfig, this.clientNodeService, this.executorManager, this.boltExchange, this.receivedDataMultiPushTaskStrategy, this.asyncHashedWheelTimer);
        receivedDataMultiPushTask.setTaskEvent(event);
        this.executorManager.getPushTaskExecutor().execute(() -> this.clientNodeSingleTaskProcessor.process((Object)receivedDataMultiPushTask));
    }

    @Override
    public PushTaskSender.PushDataType getPushDataType() {
        return PushTaskSender.PushDataType.RECEIVE_DATA;
    }

    public TaskMergeProcessorStrategy getTaskMergeProcessorStrategy() {
        return this.receiveDataTaskMergeProcessorStrategy;
    }
}

