/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.cache;

import com.alipay.sofa.registry.server.session.cache.EntityType;

public class Key {
    private String entityName;
    private String hashKey;
    private KeyType keyType;
    private EntityType entityType;

    public Key(KeyType keyType, String entityName, EntityType entityType) {
        this.keyType = keyType;
        this.entityName = entityName;
        this.entityType = entityType;
        this.hashKey = (Object)((Object)this.keyType) + this.entityName + this.entityType.getUniqueKey();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int hashCode() {
        String hashKey = this.getHashKey();
        return hashKey.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Key) {
            return this.getHashKey().equals(((Key)other).getHashKey());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{name=").append(this.entityName).append(", type=").append(this.entityType).append(", format=").append((Object)this.keyType);
        sb.append('}');
        return sb.toString();
    }

    public static enum KeyType {
        JSON,
        XML,
        OBJ;

    }
}

