/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.store;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.node.NodeOperator;
import com.alipay.sofa.registry.server.meta.repository.NodeConfirmStatusService;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.repository.VersionRepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.ws.rs.NotSupportedException;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionStoreService
implements StoreService<SessionNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionStoreService.class);
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(SessionStoreService.class, (String)"[Task]");
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private StoreService dataStoreService;
    @Autowired
    private NodeConfig nodeConfig;
    @RaftReference(uniqueId="sessionServer")
    private RepositoryService<String, RenewDecorate<SessionNode>> sessionRepositoryService;
    @RaftReference(uniqueId="sessionServer")
    private VersionRepositoryService<String> sessionVersionRepositoryService;
    @RaftReference(uniqueId="sessionServer")
    private NodeConfirmStatusService<SessionNode> sessionConfirmStatusService;

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.SESSION;
    }

    @Override
    public NodeChangeResult setNodes(List<SessionNode> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeChangeResult addNode(SessionNode sessionNode) {
        this.write.lock();
        try {
            String ipAddress = sessionNode.getNodeUrl().getIpAddress();
            this.sessionRepositoryService.put(ipAddress, new RenewDecorate<SessionNode>(sessionNode, 15L));
            this.sessionVersionRepositoryService.checkAndUpdateVersions(this.nodeConfig.getLocalDataCenter(), System.currentTimeMillis());
            this.renew(sessionNode, 30);
            this.sessionConfirmStatusService.putConfirmNode(sessionNode, DataOperator.ADD);
        }
        finally {
            this.write.unlock();
        }
        return this.dataStoreService.getNodeChangeResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(String ipAddress) {
        this.write.lock();
        try {
            RenewDecorate<SessionNode> oldRenewDecorate = this.sessionRepositoryService.remove(ipAddress);
            if (oldRenewDecorate == null) {
                LOGGER.info("Remove Session node with ipAddress:" + ipAddress + " has not existed!");
                boolean bl = false;
                return bl;
            }
            this.sessionVersionRepositoryService.checkAndUpdateVersions(this.nodeConfig.getLocalDataCenter(), System.currentTimeMillis());
            this.sessionConfirmStatusService.putConfirmNode((SessionNode)((Node)oldRenewDecorate.getRenewal()), DataOperator.REMOVE);
        }
        finally {
            this.write.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodes(Collection<SessionNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            this.write.lock();
            try {
                for (Node node : nodes) {
                    String ipAddress = node.getNodeUrl().getIpAddress();
                    RenewDecorate<SessionNode> oldRenewDecorate = this.sessionRepositoryService.remove(ipAddress);
                    if (oldRenewDecorate == null) {
                        LOGGER.warn("Remove session nodes with ipAddress:" + ipAddress + " has not existed!");
                        continue;
                    }
                    this.sessionVersionRepositoryService.checkAndUpdateVersions(this.nodeConfig.getLocalDataCenter(), System.currentTimeMillis());
                    this.sessionConfirmStatusService.putConfirmNode((SessionNode)((Node)oldRenewDecorate.getRenewal()), DataOperator.REMOVE);
                }
            }
            finally {
                this.write.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renew(SessionNode sessionNode, int duration) {
        this.write.lock();
        try {
            String ipAddress = sessionNode.getNodeUrl().getIpAddress();
            RenewDecorate<SessionNode> renewer = this.sessionRepositoryService.get(ipAddress);
            if (renewer == null) {
                LOGGER.warn("Renew session node with ipAddress:" + ipAddress + " has not existed!It will be registered again!");
                this.addNode(sessionNode);
            } else if (duration > 0) {
                this.sessionRepositoryService.replace(ipAddress, new RenewDecorate<SessionNode>(sessionNode, duration));
            } else {
                this.sessionRepositoryService.replace(ipAddress, new RenewDecorate<SessionNode>(sessionNode, 15L));
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Collection<SessionNode> getExpired() {
        ArrayList<SessionNode> renewerList = new ArrayList<SessionNode>();
        this.read.lock();
        try {
            Map<String, RenewDecorate<SessionNode>> map = this.sessionRepositoryService.getAllData();
            map.forEach((key, value) -> {
                if (value.isExpired()) {
                    renewerList.add((SessionNode)value.getRenewal());
                }
            });
        }
        finally {
            this.read.unlock();
        }
        return renewerList;
    }

    @Override
    public Map<String, SessionNode> getNodes() {
        HashMap<String, SessionNode> tmpMap = new HashMap<String, SessionNode>();
        this.read.lock();
        try {
            Map<String, RenewDecorate<SessionNode>> map = this.sessionRepositoryService.getAllData();
            map.forEach((key, value) -> {
                SessionNode cfr_ignored_0 = (SessionNode)tmpMap.put((String)key, (SessionNode)value.getRenewal());
            });
        }
        finally {
            this.read.unlock();
        }
        return tmpMap;
    }

    @Override
    public void pushNodeListChange() {
        NodeOperator<SessionNode> fireNode = this.sessionConfirmStatusService.peekConfirmNode();
        if (fireNode != null) {
            LOGGER.info("Now:type {},node {},Push queue:{}", new Object[]{fireNode.getNodeOperate(), fireNode.getNode().getNodeUrl().getIpAddress(), this.sessionConfirmStatusService.getAllConfirmNodes()});
            NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
            Map map = nodeChangeResult.getNodes();
            Map addNodes = (Map)map.get(this.nodeConfig.getLocalDataCenter());
            if (addNodes != null) {
                LOGGER.info("addNodes:{}", addNodes.keySet());
                Map<String, SessionNode> previousNodes = this.sessionConfirmStatusService.putExpectNodes(fireNode.getNode(), addNodes);
                if (!previousNodes.isEmpty()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("push Type:{},peek:{},list{}", new Object[]{fireNode.getNodeOperate(), fireNode.getNode().getNodeUrl().getIpAddress(), previousNodes.keySet()});
                    }
                    this.firePushSessionListTask(fireNode, previousNodes, nodeChangeResult);
                }
            }
        }
    }

    @Override
    public void confirmNodeStatus(String ipAddress, String confirmNodeIp) {
        NodeOperator<SessionNode> fireNode = this.sessionConfirmStatusService.peekConfirmNode();
        if (fireNode != null) {
            String fireNodeIp = fireNode.getNode().getNodeUrl().getIpAddress();
            if (fireNodeIp != null && !fireNodeIp.equals(confirmNodeIp)) {
                LOGGER.info("Confirm node already be remove from queue!Receive ip:{},expect confirm ip:{},now peek ip:{}", new Object[]{ipAddress, confirmNodeIp, fireNodeIp});
                return;
            }
            Map<String, SessionNode> waitNotifyNodes = this.sessionConfirmStatusService.getExpectNodes(fireNode.getNode());
            if (waitNotifyNodes != null) {
                LOGGER.info("Peek node:{} oper:{},waitNotifyNodes:{},confirm ip:{}", new Object[]{fireNode.getNode().getNodeUrl().getIpAddress(), fireNode.getNodeOperate(), waitNotifyNodes.keySet(), ipAddress});
                Set<String> removeIp = this.getRemoveIp(waitNotifyNodes.keySet());
                removeIp.add(ipAddress);
                waitNotifyNodes = this.sessionConfirmStatusService.removeExpectConfirmNodes(fireNode.getNode(), removeIp);
                if (waitNotifyNodes.isEmpty()) {
                    try {
                        if (null != this.sessionConfirmStatusService.removeExpectNodes(this.sessionConfirmStatusService.pollConfirmNode().getNode())) {
                            LOGGER.info("Session node {} operator {} confirm!", (Object)fireNode.getNode().getNodeUrl().getIpAddress(), (Object)fireNode.getNodeOperate());
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Notify expect confirm status node " + fireNode.getNode() + " interrupted!", (Throwable)e);
                    }
                }
            } else {
                try {
                    this.sessionConfirmStatusService.pollConfirmNode();
                    LOGGER.info("Session node {} operator {} poll!not other node need be notify!Confirm ip {}", new Object[]{fireNode.getNode().getNodeUrl().getIpAddress(), fireNode.getNodeOperate(), ipAddress});
                }
                catch (InterruptedException e) {
                    LOGGER.error("Notify expect confirm status node " + fireNode.getNode() + " interrupted!", (Throwable)e);
                }
            }
        }
    }

    private Set<String> getRemoveIp(Set<String> waitNotifyNodes) {
        NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
        Map map = nodeChangeResult.getNodes();
        Map addNodes = (Map)map.get(this.nodeConfig.getLocalDataCenter());
        if (addNodes != null && !addNodes.isEmpty()) {
            return waitNotifyNodes.stream().filter(ip -> !addNodes.keySet().contains(ip)).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private void firePushSessionListTask(NodeOperator<SessionNode> fireNode, Map<String, SessionNode> sessionNodeMap, NodeChangeResult nodeChangeResult) {
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.SESSION_NODE_CHANGE_PUSH_TASK);
        taskEvent.setAttribute("PUSH_TARGET_OPERATOR_TYPE", (Object)fireNode.getNodeOperate());
        taskEvent.setAttribute("PUSH_TARGET_SESSION_NODE", sessionNodeMap);
        taskEvent.setAttribute("PUSH_TARGET_CONFIRM_NODE", (Object)fireNode.getNode().getNodeUrl().getIpAddress());
        taskEvent.setEventObj((Object)nodeChangeResult);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " taskEvent:" + taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeChangeResult getNodeChangeResult() {
        NodeChangeResult nodeChangeResult = new NodeChangeResult(Node.NodeType.SESSION);
        String localDataCenter = this.nodeConfig.getLocalDataCenter();
        nodeChangeResult.setLocalDataCenter(localDataCenter);
        HashMap nodes = new HashMap();
        this.read.lock();
        try {
            HashMap tmpMap = new HashMap();
            Map<String, RenewDecorate<SessionNode>> map = this.sessionRepositoryService.getAllData();
            map.forEach((key, value) -> {
                Node cfr_ignored_0 = (Node)tmpMap.put(key, value.getRenewal());
            });
            nodes.put(localDataCenter, tmpMap);
            nodeChangeResult.setNodes(nodes);
            nodeChangeResult.setVersion(this.sessionVersionRepositoryService.getVersion(this.nodeConfig.getLocalDataCenter()));
        }
        finally {
            this.read.unlock();
        }
        return nodeChangeResult;
    }

    @Override
    public void getOtherDataCenterNodeAndUpdate() {
    }

    @Override
    public DataCenterNodes getDataCenterNodes() {
        Long version = this.sessionVersionRepositoryService.getVersion(this.nodeConfig.getLocalDataCenter());
        DataCenterNodes dataCenterNodes = new DataCenterNodes(Node.NodeType.SESSION, version, this.nodeConfig.getLocalDataCenter());
        dataCenterNodes.setNodes(this.getNodes());
        return dataCenterNodes;
    }

    @Override
    public void updateOtherDataCenterNodes(DataCenterNodes dataCenterNodes) {
        throw new NotSupportedException("Node type SESSION not support function");
    }

    public void setTaskListenerManager(TaskListenerManager taskListenerManager) {
        this.taskListenerManager = taskListenerManager;
    }

    public void setDataStoreService(StoreService dataStoreService) {
        this.dataStoreService = dataStoreService;
    }

    public void setNodeConfig(NodeConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
    }

    public void setSessionRepositoryService(RepositoryService<String, RenewDecorate<SessionNode>> sessionRepositoryService) {
        this.sessionRepositoryService = sessionRepositoryService;
    }

    public void setSessionVersionRepositoryService(VersionRepositoryService<String> sessionVersionRepositoryService) {
        this.sessionVersionRepositoryService = sessionVersionRepositoryService;
    }

    public NodeConfirmStatusService<SessionNode> getSessionConfirmStatusService() {
        return this.sessionConfirmStatusService;
    }

    public void setSessionConfirmStatusService(NodeConfirmStatusService<SessionNode> sessionConfirmStatusService) {
        this.sessionConfirmStatusService = sessionConfirmStatusService;
    }
}

