/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.store;

import java.io.Serializable;

public class RenewDecorate<T>
implements Serializable {
    public static final int DEFAULT_DURATION_SECS = 15;
    private T renewal;
    private long beginTimestamp;
    private volatile long lastUpdateTimestamp;
    private long duration;

    public RenewDecorate(T renewal) {
        this.renewal = renewal;
    }

    public RenewDecorate(T renewal, long durationSECS) {
        this.renewal = renewal;
        this.lastUpdateTimestamp = this.beginTimestamp = System.currentTimeMillis();
        this.duration = durationSECS * 1000L;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.lastUpdateTimestamp + this.duration;
    }

    public void renew() {
        this.lastUpdateTimestamp = System.currentTimeMillis() + this.duration;
    }

    public void renew(long durationSECS) {
        this.lastUpdateTimestamp = System.currentTimeMillis() + durationSECS * 1000L;
    }

    public T getRenewal() {
        return this.renewal;
    }

    public void setRenewal(T renewal) {
        this.renewal = renewal;
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }
}

