/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.store;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.GetChangeListRequest;
import com.alipay.sofa.registry.common.model.metaserver.MetaNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.MetaNodeService;
import com.alipay.sofa.registry.server.meta.repository.NodeRepository;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaStoreService
implements StoreService<MetaNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaStoreService.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    @Autowired
    private NodeConfig nodeConfig;
    private AtomicLong localDataCenterInitVersion = new AtomicLong(-1L);
    @Autowired
    private TaskListenerManager taskListenerManager;
    @RaftReference(uniqueId="metaServer")
    private RepositoryService<String, RenewDecorate<MetaNode>> metaRepositoryService;

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.META;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeChangeResult setNodes(List<MetaNode> metaNodes) {
        NodeChangeResult nodeChangeResult;
        this.write.lock();
        try {
            String dataCenter = this.nodeConfig.getLocalDataCenter();
            ConcurrentHashMap<String, RenewDecorate<MetaNode>> dataCenterNodesMap = new ConcurrentHashMap<String, RenewDecorate<MetaNode>>();
            for (MetaNode metaNode : metaNodes) {
                dataCenterNodesMap.put(metaNode.getIp(), new RenewDecorate<MetaNode>(metaNode, 15L));
            }
            this.metaRepositoryService.replaceAll(dataCenter, dataCenterNodesMap, System.currentTimeMillis());
            nodeChangeResult = this.getNodeChangeResult();
            this.firePushDataListTask(nodeChangeResult, "addMetaNode");
            this.firePushSessionListTask(nodeChangeResult, "addMetaNode");
            LOGGER.info("Set meta node list {} success!", metaNodes);
        }
        finally {
            this.write.unlock();
        }
        return nodeChangeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeChangeResult addNode(MetaNode metaNode) {
        NodeChangeResult nodeChangeResult;
        String ipAddress = metaNode.getNodeUrl().getIpAddress();
        this.write.lock();
        try {
            this.metaRepositoryService.put(ipAddress, new RenewDecorate<MetaNode>(metaNode, 15L));
            nodeChangeResult = this.getNodeChangeResult();
            this.firePushDataListTask(nodeChangeResult, "addMetaNode");
            this.firePushSessionListTask(nodeChangeResult, "addMetaNode");
            LOGGER.info("Add single meta node {} success!", (Object)metaNode);
        }
        finally {
            this.write.unlock();
        }
        return nodeChangeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(String ipAddress) {
        this.write.lock();
        try {
            RenewDecorate<MetaNode> dataNode = this.metaRepositoryService.remove(ipAddress);
            if (dataNode != null) {
                NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
                this.firePushDataListTask(nodeChangeResult, "removeMetaNode");
                this.firePushSessionListTask(nodeChangeResult, "removeMetaNode");
                LOGGER.info("Remove single meta node {} success!", (Object)dataNode.getRenewal());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void removeNodes(Collection<MetaNode> nodes) {
    }

    @Override
    public void confirmNodeStatus(String connectId, String ip) {
        throw new NotSupportedException("Node type META not support function");
    }

    @Override
    public void renew(MetaNode node, int duration) {
    }

    @Override
    public Collection<MetaNode> getExpired() {
        return null;
    }

    @Override
    public Map<String, MetaNode> getNodes() {
        return null;
    }

    @Override
    public NodeChangeResult getNodeChangeResult() {
        NodeChangeResult nodeChangeResult = new NodeChangeResult(Node.NodeType.META);
        String localDataCenter = this.nodeConfig.getLocalDataCenter();
        Map<String, NodeRepository> metaRepositoryMap = this.metaRepositoryService.getNodeRepositories();
        ConcurrentHashMap pushNodes = new ConcurrentHashMap();
        ConcurrentHashMap versionMap = new ConcurrentHashMap();
        metaRepositoryMap.forEach((dataCenter, metaNodeRepository) -> {
            if (localDataCenter.equalsIgnoreCase((String)dataCenter)) {
                nodeChangeResult.setVersion(metaNodeRepository.getVersion());
            }
            versionMap.put(dataCenter, metaNodeRepository.getVersion());
            Map dataMap = metaNodeRepository.getNodeMap();
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            dataMap.forEach((ip, dataNode) -> {
                MetaNode cfr_ignored_0 = (MetaNode)newMap.put(ip, dataNode.getRenewal());
            });
            pushNodes.put(dataCenter, newMap);
        });
        nodeChangeResult.setLocalDataCenter(localDataCenter);
        nodeChangeResult.setNodes(pushNodes);
        nodeChangeResult.setDataCenterListVersions(versionMap);
        return nodeChangeResult;
    }

    @Override
    public void getOtherDataCenterNodeAndUpdate() {
        MetaNodeService metaNodeService = (MetaNodeService)ServiceFactory.getNodeService(Node.NodeType.META);
        Map<String, Collection<String>> metaMap = this.nodeConfig.getMetaNodeIP();
        if (metaMap != null && metaMap.size() > 0) {
            for (String dataCenter : metaMap.keySet()) {
                try {
                    if (this.nodeConfig.getLocalDataCenter().equals(dataCenter)) continue;
                    GetChangeListRequest getChangeListRequest = new GetChangeListRequest(Node.NodeType.META, dataCenter);
                    DataCenterNodes getDataCenterNodes = metaNodeService.getDataCenterNodes(getChangeListRequest);
                    String dataCenterGet = getDataCenterNodes.getDataCenterId();
                    LOGGER.info("GetOtherDataCenterNode from DataCenter({}): {}", (Object)dataCenter, (Object)getDataCenterNodes);
                    Long version = getDataCenterNodes.getVersion();
                    if (version == null) {
                        LOGGER.error("getOtherDataCenterNodeAndUpdate from DataCenter({}), meta list version is null", (Object)dataCenter);
                        continue;
                    }
                    boolean result = this.metaRepositoryService.checkVersion(dataCenterGet, version);
                    if (!result) {
                        LOGGER.warn("getOtherDataCenterNodeAndUpdate from DataCenter({}), meta list version {} has not updated", (Object)dataCenter, (Object)version);
                        continue;
                    }
                    this.updateOtherDataCenterNodes((DataCenterNodes<MetaNode>)getDataCenterNodes);
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("getOtherDataCenterNodeAndUpdate from DataCenter(%s) error: %s", dataCenter, e.getMessage()), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOtherDataCenterNodes(DataCenterNodes<MetaNode> dataCenterNodes) {
        this.write.lock();
        try {
            String dataCenter = dataCenterNodes.getDataCenterId();
            Long version = dataCenterNodes.getVersion();
            if (version == null) {
                LOGGER.error("Request message version cant not be null!");
                return;
            }
            Map dataCenterNodesMap = dataCenterNodes.getNodes();
            LOGGER.info("update version {} Other DataCenter {} meta Nodes {}", new Object[]{version, dataCenter, dataCenterNodesMap});
            ConcurrentHashMap dataCenterNodesMapTemp = new ConcurrentHashMap();
            dataCenterNodesMap.forEach((ipAddress, metaNode) -> dataCenterNodesMapTemp.put(ipAddress, new RenewDecorate<MetaNode>((MetaNode)metaNode, 15L)));
            this.metaRepositoryService.replaceAll(dataCenter, dataCenterNodesMapTemp, version);
            if (version.longValue() == this.localDataCenterInitVersion.get()) {
                LOGGER.info("DataCenter {} first start up,No meta node change to notify!Init version {}", (Object)dataCenter, (Object)version);
                return;
            }
            NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
            this.firePushDataListTask(nodeChangeResult, "OtherDataCenterMetaUpdate");
            this.firePushSessionListTask(nodeChangeResult, "OtherDataCenterMetaUpdate");
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataCenterNodes getDataCenterNodes() {
        this.read.lock();
        try {
            String localDataCenter = this.nodeConfig.getLocalDataCenter();
            Map<String, NodeRepository> metaNodeRepositoryMap = this.metaRepositoryService.getNodeRepositories();
            NodeRepository metaNodeRepository = metaNodeRepositoryMap.get(localDataCenter);
            if (metaNodeRepository == null) {
                DataCenterNodes dataCenterNodes = new DataCenterNodes(Node.NodeType.META, Long.valueOf(this.localDataCenterInitVersion.get()), localDataCenter);
                dataCenterNodes.setNodes(new ConcurrentHashMap());
                DataCenterNodes dataCenterNodes2 = dataCenterNodes;
                return dataCenterNodes2;
            }
            DataCenterNodes dataCenterNodes = new DataCenterNodes(Node.NodeType.META, metaNodeRepository.getVersion(), localDataCenter);
            Map dataMap = metaNodeRepository.getNodeMap();
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            dataMap.forEach((ip, metaNode) -> {
                MetaNode cfr_ignored_0 = (MetaNode)newMap.put(ip, metaNode.getRenewal());
            });
            dataCenterNodes.setNodes(newMap);
            DataCenterNodes dataCenterNodes3 = dataCenterNodes;
            return dataCenterNodes3;
        }
        finally {
            this.read.unlock();
        }
    }

    private void firePushDataListTask(NodeChangeResult nodeChangeResult, String nodeOperate) {
        TaskEvent taskEvent = new TaskEvent((Object)nodeChangeResult, TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK);
        taskEvent.setAttribute("NEED_CONFIRM", (Object)false);
        taskEvent.setAttribute("PUSH_TARGET_TYPE", (Object)Node.NodeType.DATA);
        taskEvent.setAttribute("PUSH_TARGET_OPERATOR_TYPE", (Object)nodeOperate);
        LOGGER.info("send {} NodeType:{} Operator:{}", new Object[]{taskEvent.getTaskType(), Node.NodeType.DATA, nodeOperate});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void firePushSessionListTask(NodeChangeResult nodeChangeResult, String nodeOperate) {
        TaskEvent taskEvent = new TaskEvent((Object)nodeChangeResult, TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK);
        taskEvent.setAttribute("PUSH_TARGET_TYPE", (Object)Node.NodeType.SESSION);
        taskEvent.setAttribute("PUSH_TARGET_OPERATOR_TYPE", (Object)nodeOperate);
        LOGGER.info("send {} NodeType:{} Operator:{}", new Object[]{taskEvent.getTaskType(), Node.NodeType.SESSION, nodeOperate});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public void pushNodeListChange() {
    }
}

