/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="stopPushDataSwitch")
public class StopPushDataResource {
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(StopPushDataResource.class, (String)"[DBService]");
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(StopPushDataResource.class, (String)"[Task]");
    @RaftReference
    private DBService persistenceDataDBService;
    @Autowired
    private TaskListenerManager taskListenerManager;

    @GET
    @Path(value="open")
    @Produces(value={"application/json"})
    public Result closePush() {
        PersistenceData persistenceData = this.createPushDataInfo();
        persistenceData.setData("true");
        try {
            boolean ret = this.persistenceDataDBService.put("session.stop.push.data.switch#@#9600#@#CONFIG", (Object)persistenceData);
            DB_LOGGER.info("open stop push data switch to DB result {}!", (Object)ret);
        }
        catch (Exception e) {
            DB_LOGGER.error("error open stop push data switch to DB!");
            throw new RuntimeException("open stop push data switch to DB error!");
        }
        this.fireDataChangeNotify(persistenceData.getVersion(), "session.stop.push.data.switch#@#9600#@#CONFIG", DataOperator.ADD);
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="close")
    @Produces(value={"application/json"})
    public Result openPush() {
        PersistenceData persistenceData = this.createPushDataInfo();
        persistenceData.setData("false");
        try {
            boolean ret = this.persistenceDataDBService.update("session.stop.push.data.switch#@#9600#@#CONFIG", (Object)persistenceData);
            DB_LOGGER.info("close stop push data switch to DB result {}!", (Object)ret);
        }
        catch (Exception e) {
            DB_LOGGER.error("error close stop push data switch from DB!");
            throw new RuntimeException("Close stop push data switch from DB error!");
        }
        this.fireDataChangeNotify(persistenceData.getVersion(), "session.stop.push.data.switch#@#9600#@#CONFIG", DataOperator.UPDATE);
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    private PersistenceData createPushDataInfo() {
        DataInfo dataInfo = DataInfo.valueOf((String)"session.stop.push.data.switch#@#9600#@#CONFIG");
        PersistenceData persistenceData = new PersistenceData();
        persistenceData.setDataId(dataInfo.getDataId());
        persistenceData.setGroup(dataInfo.getDataType());
        persistenceData.setInstanceId(dataInfo.getInstanceId());
        persistenceData.setVersion(Long.valueOf(System.currentTimeMillis()));
        return persistenceData;
    }

    private void fireDataChangeNotify(Long version, String dataInfoId, DataOperator dataOperator) {
        NotifyProvideDataChange notifyProvideDataChange = new NotifyProvideDataChange(dataInfoId, version, dataOperator, this.getNodeTypes());
        TaskEvent taskEvent = new TaskEvent((Object)notifyProvideDataChange, TaskEvent.TaskType.PERSISTENCE_DATA_CHANGE_NOTIFY_TASK);
        TASK_LOGGER.info("send PERSISTENCE_DATA_CHANGE_NOTIFY_TASK notifyProvideDataChange:" + notifyProvideDataChange);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    protected Set<Node.NodeType> getNodeTypes() {
        return Sets.newHashSet((Object[])new Node.NodeType[]{Node.NodeType.SESSION});
    }
}

