/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.DBResponse;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="renewSwitch")
public class RenewSwitchResource {
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(RenewSwitchResource.class, (String)"[DBService]");
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(RenewSwitchResource.class, (String)"[Task]");
    @RaftReference
    private DBService persistenceDataDBService;
    @Autowired
    private TaskListenerManager taskListenerManager;

    @GET
    @Path(value="get")
    @Produces(value={"application/json"})
    public Map<String, Object> getPushSwitch() throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        DBResponse enableDataRenewSnapshot = this.persistenceDataDBService.get("session.enable.datum.renew.switch#@#9600#@#CONFIG");
        DBResponse enableDataDatumExpire = this.persistenceDataDBService.get("data.enable.datum.expire.switch#@#9600#@#CONFIG");
        resultMap.put("enableDataRenewSnapshot", enableDataRenewSnapshot != null && enableDataRenewSnapshot.getEntity() != null ? ((PersistenceData)enableDataRenewSnapshot.getEntity()).getData() : "null");
        resultMap.put("enableDataDatumExpire", enableDataDatumExpire != null && enableDataDatumExpire.getEntity() != null ? ((PersistenceData)enableDataDatumExpire.getEntity()).getData() : "null");
        return resultMap;
    }

    @GET
    @Path(value="enable")
    @Produces(value={"application/json"})
    public Result enableRenew() {
        this.invokeSession("true");
        this.invokeData("true");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="disable")
    @Produces(value={"application/json"})
    public Result disableRenew() {
        this.invokeSession("false");
        this.invokeData("false");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="session/enable")
    @Produces(value={"application/json"})
    public Result enableSessionRenew() {
        this.invokeSession("true");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="session/disable")
    @Produces(value={"application/json"})
    public Result disableSessionRenew() {
        this.invokeSession("false");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="data/enable")
    @Produces(value={"application/json"})
    public Result enableDataRenew() {
        this.invokeData("true");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @GET
    @Path(value="data/disable")
    @Produces(value={"application/json"})
    public Result disableDataRenew() {
        this.invokeData("false");
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    private void invokeSession(String data) {
        String msg = "put ENABLE_DATA_RENEW_SNAPSHOT to DB";
        PersistenceData persistenceData = this.createPersistenceData("session.enable.datum.renew.switch#@#9600#@#CONFIG");
        persistenceData.setData(data);
        try {
            boolean ret = this.persistenceDataDBService.put("session.enable.datum.renew.switch#@#9600#@#CONFIG", (Object)persistenceData);
            DB_LOGGER.info(String.format("%s result %s", msg, ret));
        }
        catch (Exception e) {
            DB_LOGGER.error(String.format("Error %s: %s", msg, e.getMessage()));
            throw new RuntimeException(String.format("Error %s: %s", msg, e.getMessage()), e);
        }
        this.fireDataChangeNotify(Node.NodeType.SESSION, persistenceData.getVersion(), "session.enable.datum.renew.switch#@#9600#@#CONFIG", DataOperator.UPDATE);
    }

    private void invokeData(String data) {
        String msg = "put ENABLE_DATA_DATUM_EXPIRE to DB";
        PersistenceData persistenceData = this.createPersistenceData("data.enable.datum.expire.switch#@#9600#@#CONFIG");
        persistenceData.setData(data);
        try {
            boolean ret = this.persistenceDataDBService.put("data.enable.datum.expire.switch#@#9600#@#CONFIG", (Object)persistenceData);
            DB_LOGGER.info(String.format("%s result %s", msg, ret));
        }
        catch (Exception e) {
            DB_LOGGER.error(String.format("Error %s: %s", msg, e.getMessage()));
            throw new RuntimeException(String.format("Error %s: %s", msg, e.getMessage()), e);
        }
        this.fireDataChangeNotify(Node.NodeType.DATA, persistenceData.getVersion(), "data.enable.datum.expire.switch#@#9600#@#CONFIG", DataOperator.UPDATE);
    }

    private PersistenceData createPersistenceData(String dataId) {
        DataInfo dataInfo = DataInfo.valueOf((String)dataId);
        PersistenceData persistenceData = new PersistenceData();
        persistenceData.setDataId(dataInfo.getDataId());
        persistenceData.setGroup(dataInfo.getDataType());
        persistenceData.setInstanceId(dataInfo.getInstanceId());
        persistenceData.setVersion(Long.valueOf(System.currentTimeMillis()));
        return persistenceData;
    }

    private void fireDataChangeNotify(Node.NodeType nodeType, Long version, String dataInfoId, DataOperator dataOperator) {
        NotifyProvideDataChange notifyProvideDataChange = new NotifyProvideDataChange(dataInfoId, version, dataOperator);
        notifyProvideDataChange.setNodeTypes((Set)Sets.newHashSet((Object[])new Node.NodeType[]{nodeType}));
        TaskEvent taskEvent = new TaskEvent((Object)notifyProvideDataChange, TaskEvent.TaskType.PERSISTENCE_DATA_CHANGE_NOTIFY_TASK);
        TASK_LOGGER.info("send PERSISTENCE_DATA_CHANGE_NOTIFY_TASK notifyProvideDataChange:" + notifyProvideDataChange);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }
}

