/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.ReporterUtils;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.store.api.DBResponse;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.OperationStatus;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="digest")
public class MetaDigestResource {
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(MetaDigestResource.class, (String)"[Resource]");
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(MetaDigestResource.class, (String)"[DBService]");
    @Autowired
    private Registry metaServerRegistry;
    @RaftReference
    private DBService persistenceDataDBService;

    @PostConstruct
    public void init() {
        MetricRegistry metrics = new MetricRegistry();
        metrics.register("metaNodeList", (Metric)((Gauge)() -> this.getRegisterNodeByType("meta")));
        metrics.register("dataNodeList", (Metric)((Gauge)() -> this.getRegisterNodeByType("data")));
        metrics.register("sessionNodeList", (Metric)((Gauge)() -> this.getRegisterNodeByType("session")));
        metrics.register("pushSwitch", (Metric)((Gauge)() -> this.getPushSwitch()));
        ReporterUtils.startSlf4jReporter((long)60L, (MetricRegistry)metrics);
    }

    @GET
    @Path(value="{type}/node/query")
    @Produces(value={"application/json"})
    public Map getRegisterNodeByType(@PathParam(value="type") String type) {
        try {
            NodeChangeResult nodeChangeResult = this.metaServerRegistry.getAllNodes(Node.NodeType.valueOf((String)type.toUpperCase()));
            return nodeChangeResult.getNodes();
        }
        catch (Exception e) {
            TASK_LOGGER.error("Fail get Register Node By Type {} !", (Object)type, (Object)e);
            throw new RuntimeException("Fail get Register Node By Type" + type, e);
        }
    }

    @GET
    @Path(value="pushSwitch")
    @Produces(value={"application/json"})
    public Map<String, Object> getPushSwitch() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        try {
            DBResponse ret = this.persistenceDataDBService.get("session.stop.push.data.switch#@#9600#@#CONFIG");
            if (ret == null) {
                resultMap.put("pushSwitch", "open");
                resultMap.put("msg", "get null Data from db!");
            } else if (ret.getOperationStatus() == OperationStatus.SUCCESS) {
                PersistenceData data = (PersistenceData)ret.getEntity();
                String result = data.getData();
                if (result != null && !result.isEmpty()) {
                    resultMap.put("pushSwitch", "false".equalsIgnoreCase(result) ? "open" : "closed");
                } else {
                    resultMap.put("pushSwitch", "open");
                    resultMap.put("msg", "data is empty");
                }
            } else if (ret.getOperationStatus() == OperationStatus.NOTFOUND) {
                resultMap.put("pushSwitch", "open");
                resultMap.put("msg", "OperationStatus is NOTFOUND");
            } else {
                DB_LOGGER.error("get Data DB status error!");
                throw new RuntimeException("Get Data DB status error!");
            }
            DB_LOGGER.info("getPushSwitch: {}", resultMap);
        }
        catch (Exception e) {
            DB_LOGGER.error("get persistence Data dataInfoId {} from db error!", (Object)"session.stop.push.data.switch#@#9600#@#CONFIG", (Object)e);
            throw new RuntimeException("Get persistence Data from db error!", e);
        }
        return resultMap;
    }
}

