/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.jraft.bootstrap.ServiceStateMachine;
import com.alipay.sofa.registry.metrics.ReporterUtils;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerBootstrap;
import com.alipay.sofa.registry.server.meta.remoting.RaftExchanger;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="health")
public class HealthResource {
    @Autowired
    private MetaServerBootstrap metaServerBootstrap;
    @Autowired
    private RaftExchanger raftExchanger;

    @PostConstruct
    public void init() {
        MetricRegistry metrics = new MetricRegistry();
        metrics.register("healthCheck", (Metric)((Gauge)() -> this.getHealthCheckResult()));
        ReporterUtils.startSlf4jReporter((long)60L, (MetricRegistry)metrics);
    }

    @GET
    @Path(value="check")
    @Produces(value={"application/json"})
    public Response checkHealth() {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        CommonResponse response = this.getHealthCheckResult();
        builder.entity((Object)response);
        if (!response.isSuccess()) {
            builder.status(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return builder.build();
    }

    private CommonResponse getHealthCheckResult() {
        boolean start;
        StringBuilder sb = new StringBuilder("MetaServerBoot ");
        boolean ret = start = this.metaServerBootstrap.getSessionStart().get();
        sb.append("sessionRegisterServer:").append(start);
        start = this.metaServerBootstrap.getDataStart().get();
        ret = ret && start;
        sb.append(", dataRegisterServerStart:").append(start);
        start = this.metaServerBootstrap.getMetaStart().get();
        ret = ret && start;
        sb.append(", otherMetaRegisterServerStart:").append(start);
        start = this.metaServerBootstrap.getHttpStart().get();
        ret = ret && start;
        sb.append(", httpServerStart:").append(start);
        start = this.raftExchanger.getServerStart().get();
        ret = ret && start;
        sb.append(", raftServerStart:").append(start);
        start = this.raftExchanger.getClientStart().get();
        ret = ret && start;
        sb.append(", raftClientStart:").append(start);
        start = this.raftExchanger.getClsStart().get();
        ret = ret && start;
        sb.append(", raftManagerStart:").append(start);
        start = ServiceStateMachine.getInstance().isLeader() || ServiceStateMachine.getInstance().isfollower();
        boolean bl = ret = ret && start;
        if (ServiceStateMachine.getInstance().isLeader()) {
            sb.append(", raftStatus:").append("Leader");
        } else if (ServiceStateMachine.getInstance().isfollower()) {
            sb.append(", raftStatus:").append("Follower");
        } else {
            sb.append(", raftStatus:").append(start);
        }
        CommonResponse response = ret ? CommonResponse.buildSuccessResponse((String)sb.toString()) : CommonResponse.buildFailedResponse((String)sb.toString());
        return response;
    }
}

