/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="blacklist")
public class BlacklistDataResource {
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(BlacklistDataResource.class, (String)"[DBService]");
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(BlacklistDataResource.class, (String)"[Task]");
    @RaftReference
    private DBService persistenceDataDBService;
    @Autowired
    private TaskListenerManager taskListenerManager;

    @POST
    @Path(value="update")
    @Produces(value={"application/json"})
    public Result blacklistPush(String config) {
        PersistenceData persistenceData = this.createDataInfo();
        persistenceData.setData(config);
        try {
            boolean ret = this.persistenceDataDBService.update("session.blacklist.data#@#9600#@#CONFIG", (Object)persistenceData);
            DB_LOGGER.info("Success update blacklist to DB result {}!", (Object)ret);
        }
        catch (Exception e) {
            DB_LOGGER.error("Error update blacklist to DB!", (Throwable)e);
            throw new RuntimeException("Update blacklist to error!");
        }
        this.fireDataChangeNotify(persistenceData.getVersion(), "session.blacklist.data#@#9600#@#CONFIG", DataOperator.UPDATE);
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    private PersistenceData createDataInfo() {
        DataInfo dataInfo = DataInfo.valueOf((String)"session.blacklist.data#@#9600#@#CONFIG");
        PersistenceData persistenceData = new PersistenceData();
        persistenceData.setDataId(dataInfo.getDataId());
        persistenceData.setGroup(dataInfo.getDataType());
        persistenceData.setInstanceId(dataInfo.getInstanceId());
        persistenceData.setVersion(Long.valueOf(System.currentTimeMillis()));
        return persistenceData;
    }

    private void fireDataChangeNotify(Long version, String dataInfoId, DataOperator dataOperator) {
        NotifyProvideDataChange notifyProvideDataChange = new NotifyProvideDataChange(dataInfoId, version, dataOperator);
        TaskEvent taskEvent = new TaskEvent((Object)notifyProvideDataChange, TaskEvent.TaskType.PERSISTENCE_DATA_CHANGE_NOTIFY_TASK);
        TASK_LOGGER.info("send PERSISTENCE_DATA_CHANGE_NOTIFY_TASK notifyProvideDataChange:" + notifyProvideDataChange);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }
}

