/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.repository.NodeRepository;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

@RaftService(uniqueId="sessionServer")
public class SessionRepositoryService
extends AbstractSnapshotProcess
implements RepositoryService<String, RenewDecorate<SessionNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionRepositoryService.class);
    @Autowired
    private NodeConfig nodeConfig;
    private ConcurrentHashMap<String, RenewDecorate<SessionNode>> registry = new ConcurrentHashMap();
    private Set<String> snapShotFileNames = new HashSet<String>();

    public SessionRepositoryService() {
    }

    public SessionRepositoryService(ConcurrentHashMap<String, RenewDecorate<SessionNode>> registry) {
        this.registry = registry;
    }

    public SnapshotProcess copy() {
        return new SessionRepositoryService(new ConcurrentHashMap<String, RenewDecorate<SessionNode>>(this.registry));
    }

    @Override
    public RenewDecorate<SessionNode> put(String ipAddress, RenewDecorate<SessionNode> sessionNode, Long currentTimeMillis) {
        try {
            RenewDecorate<SessionNode> oldRenewDecorate = this.registry.get(ipAddress);
            if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                LOGGER.info("Session node with connectId:" + ipAddress + " has already existed!");
            }
            this.registry.put(ipAddress, sessionNode);
            LOGGER.info("Put session node {} ok", (Object)ipAddress);
        }
        catch (Exception e) {
            LOGGER.error("Session node add error!", (Throwable)e);
            throw new RuntimeException("Session node add error!", e);
        }
        return sessionNode;
    }

    @Override
    public RenewDecorate<SessionNode> remove(Object key, Long currentTimeMillis) {
        try {
            String ipAddress = (String)key;
            RenewDecorate<SessionNode> oldRenewDecorate = this.registry.remove(ipAddress);
            if (oldRenewDecorate == null) {
                LOGGER.info("Remove Session node with ipAddress:" + ipAddress + " has not existed!");
                return null;
            }
            return oldRenewDecorate;
        }
        catch (Exception e) {
            LOGGER.error("Data Session remove error!", (Throwable)e);
            throw new RuntimeException("Session node remove error!", e);
        }
    }

    @Override
    public RenewDecorate<SessionNode> replace(String ipAddress, RenewDecorate<SessionNode> sessionNode, Long currentTimeMillis) {
        RenewDecorate<SessionNode> oldRenewDecorate = this.registry.get(ipAddress);
        if (oldRenewDecorate == null || oldRenewDecorate.getRenewal() == null) {
            LOGGER.error("Session node with ipAddress {} has not existed!", (Object)ipAddress);
            throw new RuntimeException(String.format("Session node with ipAddress %s has not existed!", ipAddress));
        }
        oldRenewDecorate.setRenewal(sessionNode.getRenewal());
        oldRenewDecorate.renew();
        return sessionNode;
    }

    @Override
    public RenewDecorate<SessionNode> get(Object key) {
        try {
            String ipAddress = (String)key;
            RenewDecorate<SessionNode> oldRenewDecorate = this.registry.get(ipAddress);
            if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                return oldRenewDecorate;
            }
            LOGGER.warn("Session node with ipAddress {} has not existed!It not be registered!", (Object)ipAddress);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Get Session node error!", (Throwable)e);
            throw new RuntimeException("Get Session node error!", e);
        }
    }

    @Override
    public Map<String, RenewDecorate<SessionNode>> getAllData() {
        return this.registry;
    }

    @Override
    public Map<String, Map<String, RenewDecorate<SessionNode>>> getAllDataMap() {
        ConcurrentHashMap<String, Map<String, RenewDecorate<SessionNode>>> map = new ConcurrentHashMap<String, Map<String, RenewDecorate<SessionNode>>>();
        map.put(this.nodeConfig.getLocalDataCenter(), this.registry);
        return map;
    }

    @Override
    public Map<String, RenewDecorate<SessionNode>> replaceAll(String dataCenter, Map<String, RenewDecorate<SessionNode>> map, Long version) {
        return null;
    }

    @Override
    public Map<String, NodeRepository> getNodeRepositories() {
        ConcurrentHashMap<String, NodeRepository> map = new ConcurrentHashMap<String, NodeRepository>();
        map.put(this.nodeConfig.getLocalDataCenter(), new NodeRepository(this.nodeConfig.getLocalDataCenter(), this.registry, System.currentTimeMillis()));
        return map;
    }

    public boolean save(String path) {
        return this.save(path, this.registry);
    }

    public synchronized boolean load(String path) {
        try {
            ConcurrentHashMap map = (ConcurrentHashMap)this.load(path, this.registry.getClass());
            this.registry.clear();
            this.registry.putAll(map);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load registry data error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getClass().getSimpleName());
        return this.snapShotFileNames;
    }

    @Override
    public boolean checkVersion(String key, Long version) {
        return false;
    }

    @Override
    public Long getVersion(String key) {
        return null;
    }

    public void setNodeConfig(NodeConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
    }
}

