/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.node.NodeOperator;
import com.alipay.sofa.registry.server.meta.repository.NodeConfirmStatusService;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@RaftService(uniqueId="sessionServer")
public class SessionConfirmStatusService
extends AbstractSnapshotProcess
implements NodeConfirmStatusService<SessionNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionConfirmStatusService.class);
    private ConcurrentHashMap<SessionNode, Map<String, SessionNode>> expectNodes = new ConcurrentHashMap();
    private BlockingQueue<NodeOperator> expectNodesOrders = new LinkedBlockingQueue<NodeOperator>();
    private Set<String> snapShotFileNames = new HashSet<String>();
    private static final String NODE_EXTEND_NAME = "expectNodes";
    private static final String NODE_ORDERS_EXTEND_NAME = "expectNodesOrders";

    public SessionConfirmStatusService() {
    }

    public SessionConfirmStatusService(ConcurrentHashMap<SessionNode, Map<String, SessionNode>> expectNodes, BlockingQueue<NodeOperator> expectNodesOrders) {
        this.expectNodes = expectNodes;
        this.expectNodesOrders = expectNodesOrders;
    }

    public SnapshotProcess copy() {
        return new SessionConfirmStatusService(new ConcurrentHashMap<SessionNode, Map<String, SessionNode>>(this.expectNodes), new LinkedBlockingQueue<NodeOperator>(this.expectNodesOrders));
    }

    @Override
    public void putConfirmNode(SessionNode node, DataOperator nodeOperate) {
        try {
            this.expectNodesOrders.put(new NodeOperator<SessionNode>(node, nodeOperate));
            LOGGER.info("Put operate:{} node:{} expect be confirm.", (Object)nodeOperate, (Object)node);
        }
        catch (InterruptedException e) {
            LOGGER.error("Put expect status list interrupt!", (Throwable)e);
        }
    }

    @Override
    public NodeOperator<SessionNode> peekConfirmNode() {
        return (NodeOperator)this.expectNodesOrders.peek();
    }

    @Override
    public NodeOperator<SessionNode> pollConfirmNode() throws InterruptedException {
        return this.expectNodesOrders.poll(1L, TimeUnit.SECONDS);
    }

    @Override
    public Queue<NodeOperator> getAllConfirmNodes() {
        return this.expectNodesOrders;
    }

    @Override
    public Map<String, SessionNode> putExpectNodes(SessionNode confirmNode, Map<String, SessionNode> addNodes) {
        this.expectNodes.put(confirmNode, addNodes);
        LOGGER.info("Put ExpectNodes:{} node:{} expect be confirm.expectNodes all {}", new Object[]{addNodes, confirmNode, this.expectNodes});
        return addNodes;
    }

    @Override
    public Map<String, SessionNode> getExpectNodes(SessionNode confirmNode) {
        Map<String, SessionNode> map = this.expectNodes.get(confirmNode);
        LOGGER.info("Get ExpectNodes:{} node:{} expect be confirm. expectNodes all {}", new Object[]{map, confirmNode, this.expectNodes});
        return map;
    }

    @Override
    public Map<String, SessionNode> removeExpectNodes(SessionNode confirmNode) {
        return this.expectNodes.remove(confirmNode);
    }

    @Override
    public Map<String, SessionNode> removeExpectConfirmNodes(SessionNode confirmNode, Collection<String> ips) {
        Map<String, SessionNode> map = this.expectNodes.get(confirmNode);
        if (map != null) {
            if (ips != null && !ips.isEmpty()) {
                ips.forEach(ipAddress -> {
                    SessionNode old = (SessionNode)map.remove(ipAddress);
                    if (old == null) {
                        LOGGER.warn("Get Expect confirmNode ip {} not existed!", ipAddress);
                    }
                });
            }
        } else {
            LOGGER.warn("Get Expect confirmNode {} not existed!", (Object)confirmNode);
        }
        LOGGER.info("Remove expect confirmNode:{} ips:{}. return all {}", new Object[]{confirmNode, ips, map});
        return map;
    }

    public boolean save(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Input path can't be null!");
        }
        if (path.endsWith(NODE_ORDERS_EXTEND_NAME)) {
            return this.save(path, this.expectNodesOrders);
        }
        return this.save(path, this.expectNodes);
    }

    public synchronized boolean load(String path) {
        try {
            if (path == null) {
                throw new IllegalArgumentException("Input path can't be null!");
            }
            if (path.endsWith(NODE_ORDERS_EXTEND_NAME)) {
                BlockingQueue queue = (BlockingQueue)this.load(path, this.expectNodesOrders.getClass());
                this.expectNodesOrders.clear();
                this.expectNodesOrders.addAll(queue);
            } else {
                ConcurrentHashMap map = (ConcurrentHashMap)this.load(path, this.expectNodes.getClass());
                this.expectNodes.clear();
                this.expectNodes.putAll(map);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load confirm expect Nodes data error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getExtPath(this.getClass().getSimpleName(), NODE_EXTEND_NAME));
        this.snapShotFileNames.add(this.getExtPath(this.getClass().getSimpleName(), NODE_ORDERS_EXTEND_NAME));
        return this.snapShotFileNames;
    }

    private String getExtPath(String path, String extentName) {
        return path + "_" + extentName;
    }
}

