/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.repository.NodeRepository;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;

@RaftService(uniqueId="dataServer")
public class DataRepositoryService
extends AbstractSnapshotProcess
implements RepositoryService<String, RenewDecorate<DataNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRepositoryService.class);
    @Autowired
    private NodeConfig nodeConfig;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private Map<String, NodeRepository> registry = new ConcurrentHashMap<String, NodeRepository>();
    private Set<String> snapShotFileNames = new HashSet<String>();

    public DataRepositoryService() {
    }

    public DataRepositoryService(Map<String, NodeRepository> registry) {
        this.registry = registry;
    }

    public SnapshotProcess copy() {
        return new DataRepositoryService(new ConcurrentHashMap<String, NodeRepository>(this.registry));
    }

    @Override
    public RenewDecorate<DataNode> put(String ipAddress, RenewDecorate<DataNode> dataNode, Long currentTimeMillis) {
        this.write.lock();
        try {
            NodeRepository nodeRepository;
            String dataCenter = dataNode.getRenewal().getDataCenter();
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository == null && (dataNodeRepository = this.registry.put(dataCenter, nodeRepository = new NodeRepository(dataCenter, new ConcurrentHashMap(), currentTimeMillis))) == null) {
                dataNodeRepository = nodeRepository;
            }
            dataNodeRepository.setVersion(currentTimeMillis);
            Map dataNodes = dataNodeRepository.getNodeMap();
            RenewDecorate oldRenewDecorate = dataNodes.get(ipAddress);
            if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                LOGGER.info("Data node with ipAddress:" + ipAddress + " has already existed!");
            }
            dataNodes.put(ipAddress, dataNode);
        }
        catch (Exception e) {
            LOGGER.error("Data node add error!", (Throwable)e);
            throw new RuntimeException("Data node add error!", e);
        }
        finally {
            this.write.unlock();
        }
        return dataNode;
    }

    @Override
    public RenewDecorate<DataNode> remove(Object key, Long currentTimeMillis) {
        this.write.lock();
        try {
            Map dataNodes;
            String ipAddress = (String)key;
            String dataCenter = this.nodeConfig.getLocalDataCenter();
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null && (dataNodes = dataNodeRepository.getNodeMap()) != null) {
                RenewDecorate<DataNode> oldRenewDecorate = dataNodes.remove(ipAddress);
                if (oldRenewDecorate == null) {
                    LOGGER.warn("Data node with ipAddress:" + ipAddress + " has not exist!");
                    RenewDecorate<DataNode> renewDecorate = null;
                    return renewDecorate;
                }
                dataNodeRepository.setVersion(currentTimeMillis);
                RenewDecorate<DataNode> renewDecorate = oldRenewDecorate;
                return renewDecorate;
            }
            RenewDecorate<DataNode> renewDecorate = null;
            return renewDecorate;
        }
        catch (Exception e) {
            LOGGER.error("Data node remove error!", (Throwable)e);
            throw new RuntimeException("Data node remove error!", e);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public RenewDecorate<DataNode> replace(String ipAddress, RenewDecorate<DataNode> dataNode, Long currentTimeMillis) {
        this.write.lock();
        try {
            RenewDecorate<DataNode> oldRenewDecorate;
            String dataCenter = dataNode.getRenewal().getDataCenter();
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Map dataNodes = dataNodeRepository.getNodeMap();
                oldRenewDecorate = dataNodes.get(ipAddress);
                if (oldRenewDecorate == null || oldRenewDecorate.getRenewal() == null) {
                    LOGGER.error("Data node with ipAddress {} has not existed!", (Object)ipAddress);
                    throw new RuntimeException(String.format("Data node with ipAddress %s has not existed!", ipAddress));
                }
            } else {
                LOGGER.error("Data node in dataCenter: {} has not existed!", (Object)dataCenter);
                throw new RuntimeException(String.format("Data node in dataCenter: %s has not existed!", dataCenter));
            }
            oldRenewDecorate.setRenewal(dataNode.getRenewal());
            oldRenewDecorate.renew();
            RenewDecorate<DataNode> renewDecorate = dataNode;
            return renewDecorate;
        }
        catch (Exception e) {
            LOGGER.error("Data node replace error!", (Throwable)e);
            throw new RuntimeException("Data node replace error!", e);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RenewDecorate<DataNode>> replaceAll(String dataCenter, Map<String, RenewDecorate<DataNode>> map, Long version) {
        this.write.lock();
        try {
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Map<String, RenewDecorate<DataNode>> oldMap = dataNodeRepository.getNodeMap();
                if (oldMap == null) {
                    LOGGER.warn("Data node in dataCenter: {} has not existed!", (Object)dataCenter);
                }
                dataNodeRepository.setNodeMap(map);
                dataNodeRepository.setVersion(version);
                Map<String, RenewDecorate<DataNode>> map2 = oldMap;
                return map2;
            }
            this.registry.put(dataCenter, new NodeRepository(dataCenter, map, version));
            Map<String, RenewDecorate<DataNode>> map3 = map;
            return map3;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public RenewDecorate<DataNode> get(Object key) {
        this.read.lock();
        try {
            String ipAddress = (String)key;
            String dataCenter = this.nodeConfig.getLocalDataCenter();
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Map dataNodes = dataNodeRepository.getNodeMap();
                if (dataNodes != null) {
                    RenewDecorate<DataNode> oldRenewDecorate = dataNodes.get(ipAddress);
                    if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                        RenewDecorate<DataNode> renewDecorate = oldRenewDecorate;
                        return renewDecorate;
                    }
                    LOGGER.warn("Data node with ipAddress {} has not existed!It not be registered!", (Object)ipAddress);
                    RenewDecorate<DataNode> renewDecorate = null;
                    return renewDecorate;
                }
                LOGGER.warn("Data node map has not existed in dataCenter:{}!", (Object)dataCenter);
                RenewDecorate<DataNode> renewDecorate = null;
                return renewDecorate;
            }
            try {
                LOGGER.error("Data node in dataCenter: {} has not existed!", (Object)dataCenter);
                throw new RuntimeException(String.format("Data node in dataCenter: %s has not existed!", dataCenter));
            }
            catch (Exception e) {
                LOGGER.error("Get Data node error!", (Throwable)e);
                throw new RuntimeException("Get Data node error!", e);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, RenewDecorate<DataNode>> getAllData() {
        this.read.lock();
        try {
            ConcurrentHashMap<String, RenewDecorate<DataNode>> nodes = new ConcurrentHashMap<String, RenewDecorate<DataNode>>();
            this.registry.forEach((dataCenter, dataNodeRepository) -> nodes.putAll(dataNodeRepository.getNodeMap()));
            ConcurrentHashMap<String, RenewDecorate<DataNode>> concurrentHashMap = nodes;
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, Map<String, RenewDecorate<DataNode>>> getAllDataMap() {
        ConcurrentHashMap<String, Map<String, RenewDecorate<DataNode>>> nodes = new ConcurrentHashMap<String, Map<String, RenewDecorate<DataNode>>>();
        this.read.lock();
        try {
            this.registry.forEach((dataCenter, dataNodeRepository) -> nodes.put((String)dataCenter, dataNodeRepository.getNodeMap()));
            ConcurrentHashMap<String, Map<String, RenewDecorate<DataNode>>> concurrentHashMap = nodes;
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, NodeRepository> getNodeRepositories() {
        return this.registry;
    }

    public void setNodeConfig(NodeConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
    }

    public boolean save(String path) {
        return this.save(path, this.registry);
    }

    public synchronized boolean load(String path) {
        try {
            Map map = (Map)this.load(path, this.registry.getClass());
            this.registry.clear();
            this.registry.putAll(map);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load registry data error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getClass().getSimpleName());
        return this.snapShotFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkVersion(String dataCenter, Long version) {
        this.read.lock();
        try {
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Long oldValue = dataNodeRepository.getVersion();
                if (oldValue == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = version > oldValue;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getVersion(String dataCenter) {
        this.read.lock();
        try {
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Long l = dataNodeRepository.getVersion();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.read.unlock();
        }
    }
}

