/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.RenewNodesRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class RenewNodesRequestHandler
extends AbstractServerHandler<RenewNodesRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenewNodesRequestHandler.class);
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, RenewNodesRequest renewNodesRequest) {
        Node renewNode = null;
        try {
            renewNode = renewNodesRequest.getNode();
            this.metaServerRegistry.renew(renewNode, renewNodesRequest.getDuration());
        }
        catch (Exception e) {
            LOGGER.error("Node " + renewNode + "renew error!", (Throwable)e);
            throw new RuntimeException("Node renew error!", e);
        }
        return null;
    }

    @Override
    public Class interest() {
        return RenewNodesRequest.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }
}

