/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.registry;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import java.util.Collection;
import java.util.List;

public class MetaServerRegistry
implements Registry<Node> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaServerRegistry.class);

    @Override
    public NodeChangeResult setNodes(List<Node> nodes) {
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("Nodes is empty: " + nodes);
        }
        StoreService storeService = ServiceFactory.getStoreService(nodes.get(0).getNodeType());
        return storeService.setNodes(nodes);
    }

    @Override
    public NodeChangeResult register(Node node) {
        StoreService storeService = ServiceFactory.getStoreService(node.getNodeType());
        return storeService.addNode(node);
    }

    @Override
    public void cancel(String connectId, Node.NodeType nodeType) {
        StoreService storeService = ServiceFactory.getStoreService(nodeType);
        storeService.removeNode(connectId);
    }

    @Override
    public void evict() {
        for (Node.NodeType nodeType : Node.NodeType.values()) {
            Collection expiredNodes;
            StoreService storeService = ServiceFactory.getStoreService(nodeType);
            if (storeService == null || (expiredNodes = storeService.getExpired()) == null || expiredNodes.isEmpty()) continue;
            storeService.removeNodes(expiredNodes);
            LOGGER.info("Expired Nodes {} be evicted!", expiredNodes);
        }
    }

    @Override
    public void renew(Node node, int duration) {
        StoreService storeService = ServiceFactory.getStoreService(node.getNodeType());
        storeService.renew(node, duration);
    }

    @Override
    public void getOtherDataCenterNodeAndUpdate(Node.NodeType nodeType) {
        StoreService storeService = ServiceFactory.getStoreService(nodeType);
        storeService.getOtherDataCenterNodeAndUpdate();
    }

    @Override
    public DataCenterNodes getDataCenterNodes(Node.NodeType nodeType) {
        StoreService storeService = ServiceFactory.getStoreService(nodeType);
        return storeService.getDataCenterNodes();
    }

    @Override
    public NodeChangeResult getAllNodes(Node.NodeType nodeType) {
        StoreService storeService = ServiceFactory.getStoreService(nodeType);
        return storeService.getNodeChangeResult();
    }

    @Override
    public void pushNodeListChange(Node.NodeType nodeType) {
        StoreService storeService = ServiceFactory.getStoreService(nodeType);
        if (storeService != null) {
            storeService.pushNodeListChange();
        }
    }
}

