/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.node.impl;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.GetChangeListRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.meta.node.MetaNodeService;
import com.alipay.sofa.registry.server.meta.remoting.MetaClientExchanger;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaNodeServiceImpl
implements MetaNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaNodeServiceImpl.class);
    @Autowired
    private MetaClientExchanger metaClientExchanger;

    @Override
    public DataCenterNodes getDataCenterNodes(final GetChangeListRequest getChangeListRequest) {
        try {
            Request<GetChangeListRequest> changeListRequest = new Request<GetChangeListRequest>(){

                public GetChangeListRequest getRequestBody() {
                    return getChangeListRequest;
                }

                public URL getRequestUrl() {
                    return MetaNodeServiceImpl.this.metaClientExchanger.getDataCenterUrl(getChangeListRequest.getDataCenterId());
                }
            };
            Response response = this.metaClientExchanger.request((Request)changeListRequest);
            Object result = response.getResult();
            if (result instanceof DataCenterNodes) {
                return (DataCenterNodes)result;
            }
            LOGGER.error("getDataCenterNodes has not get response or response type illegal!");
            throw new RuntimeException("getDataCenterNodes has not get response or response type illegal!");
        }
        catch (RequestException e) {
            throw new RuntimeException("MetaNodeService get DataCenter Nodes error! " + e.getMessage(), e);
        }
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.META;
    }
}

