/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.executor;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.MetaClientExchanger;
import com.alipay.sofa.registry.server.meta.remoting.RaftExchanger;
import com.alipay.sofa.registry.task.scheduler.TimedSupervisorTask;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutorManager {
    private ScheduledExecutorService scheduler;
    private ThreadPoolExecutor heartbeatCheckExecutor;
    private ThreadPoolExecutor checkDataChangeExecutor;
    private ThreadPoolExecutor getOtherDataCenterChangeExecutor;
    private ThreadPoolExecutor connectMetaServerExecutor;
    private ThreadPoolExecutor checkNodeListChangePushExecutor;
    private ThreadPoolExecutor raftClientRefreshExecutor;
    private MetaServerConfig metaServerConfig;
    @Autowired
    private Registry metaServerRegistry;
    @Autowired
    private MetaClientExchanger metaClientExchanger;
    @Autowired
    private RaftExchanger raftExchanger;

    public ExecutorManager(MetaServerConfig metaServerConfig) {
        this.metaServerConfig = metaServerConfig;
    }

    public void init() {
        this.scheduler = new ScheduledThreadPoolExecutor(this.metaServerConfig.getMetaSchedulerPoolSize(), (ThreadFactory)new NamedThreadFactory("MetaScheduler"));
        this.heartbeatCheckExecutor = new ThreadPoolExecutor(this.metaServerConfig.getHeartbeatCheckExecutorMinSize(), this.metaServerConfig.getHeartbeatCheckExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getHeartbeatCheckExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-HeartbeatCheck"));
        this.heartbeatCheckExecutor.allowCoreThreadTimeOut(true);
        this.checkDataChangeExecutor = new ThreadPoolExecutor(this.metaServerConfig.getCheckDataChangeExecutorMinSize(), this.metaServerConfig.getCheckDataChangeExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getCheckDataChangeExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-CheckDataChange"));
        this.checkDataChangeExecutor.allowCoreThreadTimeOut(true);
        this.getOtherDataCenterChangeExecutor = new ThreadPoolExecutor(this.metaServerConfig.getGetOtherDataCenterChangeExecutorMinSize(), this.metaServerConfig.getGetOtherDataCenterChangeExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getGetOtherDataCenterChangeExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-GetOtherDataCenterChange"));
        this.getOtherDataCenterChangeExecutor.allowCoreThreadTimeOut(true);
        this.connectMetaServerExecutor = new ThreadPoolExecutor(this.metaServerConfig.getConnectMetaServerExecutorMinSize(), this.metaServerConfig.getConnectMetaServerExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getConnectMetaServerExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-ConnectMetaServer"));
        this.connectMetaServerExecutor.allowCoreThreadTimeOut(true);
        this.checkNodeListChangePushExecutor = new ThreadPoolExecutor(this.metaServerConfig.getCheckNodeListChangePushExecutorMinSize(), this.metaServerConfig.getCheckNodeListChangePushExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getCheckDataChangeExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-CheckNodeListChangePush"));
        this.checkNodeListChangePushExecutor.allowCoreThreadTimeOut(true);
        this.raftClientRefreshExecutor = new ThreadPoolExecutor(this.metaServerConfig.getRaftClientRefreshExecutorMinSize(), this.metaServerConfig.getRaftClientRefreshExecutorMaxSize(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.metaServerConfig.getRaftClientRefreshExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("MetaScheduler-RaftClientRefresh"));
        this.raftClientRefreshExecutor.allowCoreThreadTimeOut(true);
    }

    public void startScheduler() {
        this.init();
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("HeartbeatCheck", this.scheduler, this.heartbeatCheckExecutor, this.metaServerConfig.getSchedulerHeartbeatTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerHeartbeatExpBackOffBound(), () -> this.metaServerRegistry.evict()), (long)this.metaServerConfig.getSchedulerHeartbeatFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("GetOtherDataCenterChange", this.scheduler, this.getOtherDataCenterChangeExecutor, this.metaServerConfig.getSchedulerGetDataChangeTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerGetDataChangeExpBackOffBound(), () -> {
            this.metaServerRegistry.getOtherDataCenterNodeAndUpdate(Node.NodeType.DATA);
            this.metaServerRegistry.getOtherDataCenterNodeAndUpdate(Node.NodeType.META);
        }), (long)this.metaServerConfig.getSchedulerGetDataChangeFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ConnectMetaServer", this.scheduler, this.connectMetaServerExecutor, this.metaServerConfig.getSchedulerConnectMetaServerTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerConnectMetaServerExpBackOffBound(), () -> this.metaClientExchanger.connectServer()), (long)this.metaServerConfig.getSchedulerConnectMetaServerFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("CheckSessionNodeListChangePush", this.scheduler, this.checkNodeListChangePushExecutor, this.metaServerConfig.getSchedulerCheckNodeListChangePushTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerCheckNodeListChangePushExpBackOffBound(), () -> this.metaServerRegistry.pushNodeListChange(Node.NodeType.SESSION)), (long)this.metaServerConfig.getSchedulerCheckNodeListChangePushFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("CheckDataNodeListChangePush", this.scheduler, this.checkNodeListChangePushExecutor, this.metaServerConfig.getSchedulerCheckNodeListChangePushTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerCheckNodeListChangePushExpBackOffBound(), () -> this.metaServerRegistry.pushNodeListChange(Node.NodeType.DATA)), (long)this.metaServerConfig.getSchedulerCheckNodeListChangePushFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("RaftClientRefresh", this.scheduler, this.raftClientRefreshExecutor, this.metaServerConfig.getSchedulerCheckNodeListChangePushTimeout(), TimeUnit.SECONDS, this.metaServerConfig.getSchedulerCheckNodeListChangePushExpBackOffBound(), () -> this.raftExchanger.refreshRaftClient()), (long)this.metaServerConfig.getSchedulerCheckNodeListChangePushFirstDelay(), TimeUnit.SECONDS);
    }

    public void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        if (this.heartbeatCheckExecutor != null && !this.heartbeatCheckExecutor.isShutdown()) {
            this.heartbeatCheckExecutor.shutdown();
        }
        if (this.checkDataChangeExecutor != null && !this.checkDataChangeExecutor.isShutdown()) {
            this.checkDataChangeExecutor.shutdown();
        }
        if (this.connectMetaServerExecutor != null && !this.connectMetaServerExecutor.isShutdown()) {
            this.connectMetaServerExecutor.shutdown();
        }
        if (this.getOtherDataCenterChangeExecutor != null && !this.getOtherDataCenterChangeExecutor.isShutdown()) {
            this.getOtherDataCenterChangeExecutor.shutdown();
        }
        if (this.checkNodeListChangePushExecutor != null) {
            this.checkNodeListChangePushExecutor.isShutdown();
        }
        if (this.raftClientRefreshExecutor != null) {
            this.raftClientRefreshExecutor.isShutdown();
        }
    }
}

