/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.task;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.StatusConfirmRequest;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.node.DataNodeService;
import com.alipay.sofa.registry.server.meta.task.AbstractMetaServerTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;

public class ReceiveStatusConfirmNotifyTask
extends AbstractMetaServerTask {
    private final DataNodeService dataNodeService;
    private final MetaServerConfig metaServerConfig;
    private DataNode dataNode;

    public ReceiveStatusConfirmNotifyTask(DataNodeService dataNodeService, MetaServerConfig metaServerConfig) {
        this.dataNodeService = dataNodeService;
        this.metaServerConfig = metaServerConfig;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof DataNode)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.dataNode = (DataNode)obj;
    }

    public void execute() {
        StatusConfirmRequest statusConfirmRequest = new StatusConfirmRequest((Node)this.dataNode, this.dataNode.getNodeStatus());
        this.dataNodeService.notifyStatusConfirm(statusConfirmRequest);
    }

    public String toString() {
        return "RECEIVE_STATUS_CONFIRM_NOTIFY_TASK{taskId='" + this.taskId + '\'' + ", dataNode=" + this.dataNode + '}';
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.metaServerConfig.getReceiveStatusConfirmNotifyTaskRetryTimes());
    }
}

