/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.repository.VersionRepositoryService;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import com.alipay.sofa.registry.util.VersionsMapUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@RaftService(uniqueId="sessionServer")
public class SessionVersionRepositoryService
extends AbstractSnapshotProcess
implements VersionRepositoryService<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionVersionRepositoryService.class);
    private ConcurrentHashMap<String, Long> dataCenterListVersions = new ConcurrentHashMap();
    private Set<String> snapShotFileNames = new HashSet<String>();

    public SessionVersionRepositoryService() {
    }

    public SessionVersionRepositoryService(ConcurrentHashMap<String, Long> dataCenterListVersions) {
        this.dataCenterListVersions = dataCenterListVersions;
    }

    public SnapshotProcess copy() {
        return new SessionVersionRepositoryService(new ConcurrentHashMap<String, Long>(this.dataCenterListVersions));
    }

    @Override
    public boolean checkAndUpdateVersions(String dataCenterId, Long version) {
        return VersionsMapUtils.checkAndUpdateVersions(this.dataCenterListVersions, (String)dataCenterId, (Long)version);
    }

    @Override
    public Long getVersion(String dataCenterId) {
        return this.dataCenterListVersions.get(dataCenterId);
    }

    public boolean save(String path) {
        return this.save(path, this.dataCenterListVersions);
    }

    public synchronized boolean load(String path) {
        try {
            ConcurrentHashMap map = (ConcurrentHashMap)this.load(path, this.dataCenterListVersions.getClass());
            this.dataCenterListVersions.clear();
            this.dataCenterListVersions.putAll(map);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load dataCenter versions data error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getClass().getSimpleName());
        return this.snapShotFileNames;
    }
}

