/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaClientExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClientExchanger.class);
    @Autowired
    private MetaServerConfig metaServerConfig;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private NodeConfig nodeConfig;
    private Map<String, URL> dataCenterUrlMap = new ConcurrentHashMap<String, URL>();
    private static final int RETRY_TIMES = 3;

    public Response request(Request request) throws RequestException {
        Response response;
        try {
            Channel channel;
            Client metaClient = this.boltExchange.getClient("metaServer");
            URL url = request.getRequestUrl();
            if (metaClient == null) {
                LOGGER.warn("MetaClient Exchanger get metaServer connection {} error! Connection can not be null or disconnected!", (Object)url);
                metaClient = this.boltExchange.connect("metaServer", url, (Object[])new ChannelHandler[0]);
            }
            if ((channel = metaClient.getChannel(url)) == null) {
                LOGGER.warn("MetaClient Exchanger get channel {} error or disconnected!", (Object)url);
                channel = metaClient.connect(url);
            }
            Object result = metaClient.sendSync(channel, request.getRequestBody(), this.metaServerConfig.getMetaNodeExchangeTimeout());
            response = () -> result;
        }
        catch (Exception e) {
            LOGGER.error("MetaClient Exchanger request data error!", (Throwable)e);
            throw new RequestException("MetaClient Exchanger request data error!", request, (Throwable)e);
        }
        return response;
    }

    public Client connectServer() {
        this.connectOtherMetaServer();
        return null;
    }

    public void connectOtherMetaServer() {
        Map<String, Collection<String>> configMetaNodeIP = this.nodeConfig.getMetaNodeIP();
        StoreService storeService = ServiceFactory.getStoreService(Node.NodeType.META);
        NodeChangeResult nodeChangeResult = storeService.getNodeChangeResult();
        Map registerNodes = nodeChangeResult.getNodes();
        configMetaNodeIP.forEach((dataCenter, ips) -> {
            ArrayList metaIps = new ArrayList();
            if (!this.nodeConfig.getLocalDataCenter().equalsIgnoreCase((String)dataCenter)) {
                if (registerNodes != null && registerNodes.get(dataCenter) != null) {
                    Map metaNodeMap = (Map)registerNodes.get(dataCenter);
                    metaIps.addAll(metaNodeMap.keySet());
                } else {
                    metaIps.addAll(ips);
                }
                Collections.shuffle(metaIps);
                String ip = (String)metaIps.iterator().next();
                try {
                    URL url = new URL(ip, this.metaServerConfig.getMetaServerPort());
                    Client metaClient = this.boltExchange.getClient("metaServer");
                    if (metaClient != null && metaClient.getChannel(url) != null) {
                        return;
                    }
                    this.boltExchange.connect("metaServer", url, (Object[])new ChannelHandler[0]);
                    this.dataCenterUrlMap.putIfAbsent((String)dataCenter, url);
                    LOGGER.info("Connect other meta server success! url:" + url);
                }
                catch (Exception e) {
                    LOGGER.error("Connect other meta server error! IP:" + ip, (Throwable)e);
                }
            }
        });
    }

    public URL getDataCenterUrl(String dataCenter) {
        try {
            Client metaClient;
            URL url = this.dataCenterUrlMap.get(dataCenter);
            if (url != null && (metaClient = this.boltExchange.getClient("metaServer")) != null && metaClient.getChannel(url) != null) {
                return url;
            }
            Map<String, Collection<String>> configMetaNodeIP = this.nodeConfig.getMetaNodeIP();
            StoreService storeService = ServiceFactory.getStoreService(Node.NodeType.META);
            Map registerNodes = storeService.getNodeChangeResult().getNodes();
            ArrayList<Object> metaIps = new ArrayList<Object>();
            if (registerNodes != null && registerNodes.get(dataCenter) != null) {
                metaIps.addAll(((Map)registerNodes.get(dataCenter)).keySet());
            } else {
                metaIps.addAll(configMetaNodeIP.get(dataCenter));
            }
            Collections.shuffle(metaIps);
            String ip = (String)metaIps.iterator().next();
            URL newUrl = new URL(ip, this.metaServerConfig.getMetaServerPort());
            for (int i = 0; i <= 3; ++i) {
                try {
                    this.boltExchange.connect("metaServer", newUrl, (Object[])new ChannelHandler[0]);
                    this.dataCenterUrlMap.put(dataCenter, newUrl);
                    LOGGER.info("Connect other meta server success! url:" + newUrl);
                    continue;
                }
                catch (Exception e) {
                    int remain = 3 - i;
                    if (remain > 0) {
                        LOGGER.error("Connect other meta server error!retry time remain {}", (Object)remain, (Object)e);
                        TimeUnit.MILLISECONDS.sleep(1000L);
                        continue;
                    }
                    LOGGER.error("Connect other meta server error!retry all error!", (Throwable)e);
                    throw new RuntimeException("Connect other meta server error!", e);
                }
            }
            return newUrl;
        }
        catch (Exception e) {
            LOGGER.error("Get other meta server url error!", (Throwable)e);
            throw new RuntimeException("Get other meta server url error!", e);
        }
    }
}

